function clearAllInterval() {
    const intervalId = window.setInterval('', 9999);

    for (let i = 1; i < intervalId; i++)
        window.clearInterval(i);
}

function startTimers() {
    const items = document.querySelectorAll('[data-auction-item]');
    items.forEach(el => {
        const timeElement = el.querySelector('[data-print-time]');
        const end = Number(el.dataset.timeEnd);
        const time = Number(el.dataset.time);
        const now = Number(el.dataset.now);

        if (time) {
            let diff = time - (now - end);

            const interval = setInterval(() => {
                if ((diff - 1) >= 0) {
                    let min = Number(diff / 60);
                    let seg = diff % 60;

                    if (min < 10) {
                        min = `0${min}`;
                        min = min.substr(0, 2);
                    }

                    if (seg <= 9) {
                        seg = `0${seg}`;
                    }

                    timeElement.innerText = `${min}:${seg}`;

                    diff--;
                } else {
                    clearInterval(interval);
                }
            }, 1000);
        }
    })
}

DOMLoaded(() => {
    // if (use_pusher) {
    //     Pusher.logToConsole = true;
    //     var pusher = new Pusher(pusher_auth_key, {
    //         cluster: 'us2',
    //         forceTLS: true
    //     });
    //
    //     var channel = pusher.subscribe('auction');
    //     channel.bind('bid', function (data) {
    //         clearAllInterval();
    //
    //         var id = data.id;
    //         var $item = $('.auction-items [data-id=' + id + ']');
    //
    //         if ($item.size() > 0) {
    //             $item.attr('data-time', data.best_bid_datetime);
    //             $item.attr('data-now', (new Date()).getTime() / 1000);
    //         }
    //
    //         startTimers();
    //     });
    //
    //     channel.bind('close', function (data) {
    //         clearAllInterval();
    //
    //         var id = data.id;
    //         var $item = $('.auction-items [data-id=' + id + ']');
    //
    //         if ($item.size() > 0) {
    //             $item.remove();
    //         }
    //
    //         startTimers();
    //     });
    // }

    startTimers();

    const auctionBidElements = document.querySelectorAll('[data-auction-bid]')
    auctionBidElements.forEach(auctionBidElement => {
        auctionBidElement.addEventListener('click', async e => {
            e.preventDefault();

            const res = await fetch(`${window.Morpheus.basePath}auction/items/info/${auctionBidElement.dataset.auctionBid}`);
            const data = await res.json();

            const description = `${data.text_initial_bid}: ${data.initial_bid} ${data.coin} - ${data.text_best_bid}: ${data.best_bid} ${data.coin}`;

            window.Morpheus.dialog.prompt(data.text_bid, description, async result => {
                if (result.isConfirmed) {
                    window.Morpheus.form.button(auctionBidElement, 'loading');

                    const formData = new FormData();
                    formData.append('bid', result.value);
                    formData.append('_token', document.querySelector('meta[name="csrf-token"]').getAttribute('content'))
                    const res2 = await fetch(auctionBidElement.getAttribute('href'), {
                        method: 'POST',
                        headers: {
                            accept: 'application/json'
                        },
                        body: formData
                    })
                    const json = await res2.json();

                    if (json.success) {
                        window.Morpheus.dialog.success(json.message, () => {
                            if (json.redirect) {
                                window.location = json.redirect
                            }
                        });
                    } else {
                        window.Morpheus.dialog.error(json.message);
                    }

                    window.Morpheus.form.button(auctionBidElement, 'reset');
                }
            });
        })
    })
});