function paypalButton() {
    const button = document.getElementById('paypal-button-container');
    if (button !== null) {
        const order = JSON.parse(button.dataset.order);

        paypal.Buttons({
            style: {
                label: 'checkout',
                size: 'medium',
                shape: 'pill',
                color: 'gold',
                layout: 'vertical'
            },
            createOrder: function () {
                const form = new FormData();
                form.append('order_id', order.id);
                form.append('_token', document.querySelector('[name="csrf-token"]').getAttribute('content'));

                return fetch(`${window.Morpheus.basePath}donate/checkout/paypal/${order.id}`, {
                    method: 'post',
                    body: form
                })
                .then(response => response.json())
                .then(order => order.id)
                .catch(err => console.info(err));
            },
            onApprove: function (data) {
                const form = new FormData();
                form.append('order_id', data.orderID);
                form.append('_token', document.querySelector('[name="csrf-token"]').getAttribute('content'));

                return fetch(`${window.Morpheus.basePath}donate/capture/paypal/${order.id}`, {
                    method: 'post',
                    body: form
                })
                .then(response => response.json())
                .then(orderData => {
                    window.location = `${window.Morpheus.basePath}donate`
                });
            },
        }).render("#paypal-button-container");
    }
}

function refreshDonateConfirmPage() {
    const refreshPage = document.querySelector('[data-donate-refresh-page]');
    if (refreshPage !== null) {
        const orderId = refreshPage.dataset.orderId;
        let interval;
        interval = setInterval(() => {
            fetch(`${window.Morpheus.basePath}donate/order/status/${orderId}`)
                .then(response => response.json())
                .then(orderData => {
                    if (Number(orderData.status) === 4) {
                        window.location.reload()
                        clearInterval(interval)
                    }
                })
        }, 2000)
    }
}

DOMLoaded(() => {
    paypalButton();
    refreshDonateConfirmPage();
})