async function showPollResult(areaElement) {
    const lastActivePoll = document.querySelector('[data-widget="last-active-poll"]');
    const pollId = lastActivePoll.dataset.id;
    const response = await fetch(`${window.Morpheus.basePath}polls/result/${pollId}`);
    const html = await response.text();

    const result = lastActivePoll.querySelector('.poll-result');
    if (result) {
        result.remove();
    }

    if (areaElement === 'inner') {
        lastActivePoll.innerHTML = html;
    } else if (areaElement === 'after') {
        lastActivePoll.insertAdjacentHTML('beforeend', html);
    }
}

DOMLoaded(() => {
    const polls = document.querySelectorAll("[data-form-poll-request]");

    polls.forEach(el => {
        el.addEventListener('submit', async e => {
            e.preventDefault();

            const button = el.querySelector('button[type=submit]');

            window.Morpheus.form.button(button, 'loading');

            try {
                const response = await window.Morpheus.form.submit(el);

                window.Morpheus.dialog.success(response.message);

                if (response.allow_ips) {
                    showPollResult('after');
                } else {
                    showPollResult('inner');
                }

                el.reset();
            } catch (err) {
                const error = typeof(err.error) === 'object' ? err.error : err;
                const message = error.error ?? error.message ?? null;

                if (message) {
                    window.Morpheus.dialog.error(message);
                }
            } finally {
                window.Morpheus.form.button(button, 'reset');
            }
        });
    });

    const showResultAction = document.querySelector('[data-show-result-action]');
    if (showResultAction) {
        showResultAction.addEventListener('click', e => {
            showPollResult('after');

            e.preventDefault();
        });
    }
});