DOMLoaded(() => {
    (async () => {
        const response = await fetch(`${window.Morpheus.basePath}streamers/online`);
        const json = await response.json();

        let html = '';

        for (let i = 0; i < json.streamers.length; i++) {
            const stream = json.streamers[i];

            html += [`<a class="streamers-streamer" href="${stream.link}" target="_blank" title="${stream.title}" rel="noopener noreferrer">`,
                `<div class="streamers-streamer-name">${stream.name}</div>`,
                '<div class="streamers-streamer-thumb">',
                `<img src="${stream.thumbnail_url.replace('{width}', 100).replace('{height}', 80)}" alt="${stream.name}" width="100" height="80">`,
                '<div class="streamers-streamer-thumb-user">',
                `<img src="${stream.profile_image_url}" height="40" alt="${stream.name}">`,
                '</div>',
                '</div>',
                '</a>'].join('');
        }

        if (html !== '') {
            const container = document.querySelector('[data-streamers]');
            const streamersOnlineContainer = document.querySelector('[data-streamers-online]');
            if (streamersOnlineContainer) {
                streamersOnlineContainer.innerHTML = html;
                container.classList.add('is-loaded');
            }
        }
    })();

    const toggleStreamers = document.querySelector('[data-toggle-streamers]');
    if (toggleStreamers) {
        toggleStreamers.addEventListener('click', e => {
            const container = document.querySelector('[data-streamers]');
            const onlineContainer = document.querySelector('[data-streamers-online]');
            const isOpen = container.classList.contains('is-open');

            if (isOpen) {
                container.classList.remove('is-open');
                container.style.right = '0';
            } else {
                container.classList.add('is-open');
                container.style.right = `-${onlineContainer.offsetWidth - 20}px`;
            }

            e.preventDefault();
        });
    }
})




// $(function () {
//
//     $.getJSON($.morpheus.base_path + "ajax/streamers/online", function (data) {
//
//         var html = '';
//         for (var i = 0; i < data.onlines.length; i++) {
//             var stream = data.onlines[i];
//
//             html += ['<a class="streamers__streamer" href="' + stream.link + '" target="_blank" title="' + stream.title + '">',
//                 '<div class="streamers__streamer-name">' + stream.name + '</div>',
//                 '<div class="streamers__streamer-thumb">',
//                 '<img src="' + stream.thumbnail_url.replace('{width}', 100).replace('{height}', 80) + '">',
//                 '<div class="streamers__streamer-thumb-user">',
//                 '<img src="' + stream.profile_image_url + '" height="40">',
//                 '</div>',
//                 '</div>',
//                 '</a>'].join('');
//         }
//
//         if (html !== '') {
//             $("[data-streamers-online]").html(html);
//
//             setTimeout(function () {
//                 var $container = $("[data-streamers]");
//                 var width = $container.width();
//
//                 $container.css('display', 'flex').css('right', '-' + width + 'px');
//                 $container.animate({
//                     right: 0
//                 }, 1000);
//             }, 100);
//
//         }
//     });
//
//     $(document).on("click", "[data-toggle-streamers]", function (e) {
//         var $container = $("[data-streamers]");
//         var width = $("[data-streamers-online]").width();
//         var right = $container.css('right');
//
//         if (right === '0px') {
//             $container.animate({
//                 right: '-' + width + 'px'
//             }, 1000);
//         } else {
//             $container.animate({
//                 right: 0
//             }, 1000);
//         }
//
//         e.preventDefault();
//     });
//
// });