var events = [
  ["Blood Castle",["00:00","02:00","04:00","06:00","08:00","10:00","12:00","14:00","16:00","18:00","20:00","22:00"]],
  ["Chaos Castle",["01:00","03:00","05:00","07:00","09:00","11:00","13:00","15:00","17:00","19:00","21:00","23:00"]],
  ["Devil Square",["00:30","04:30","08:30","12:30","16:30","20:30"]],
  ["Illusion Temple",["01:30","05:30","09:30","13:30","17:30","21:30"]],
  ["Moss Merchant",["02:00","08:00","14:00","20:30"]],
  ["CryWolf",[4,7],["20:30","20:30"]],
  ["CryWolf",[4,7],["20:30","20:30"]],
  ["CryWolf",[4,7],["20:30","20:30"]],
];

var eventsTime = [

];



function toSeconds(h, m, s) {
  return h * 3600 + m * 60 + s;
}

function DateUTC(offset) {
  var d = new Date();
  var utc = d.getTime() + (d.getTimezoneOffset() * 60000);
  return new Date(utc + (3600000 * offset));
}

function updateEventsTime(eventsTime, divId) {
  var d = DateUTC('-2');
  var time = toSeconds(d.getHours(), d.getMinutes(), d.getSeconds());

  var html = '';
  for (var i in eventsTime) {
    var line = eventsTime[i];

    if (line.length == 2 && typeof(line[1]) == 'object') {
      var j;
      for (j = 0; j < line[1].length; j++) {
        var t = line[1][j].split(':');
        t = toSeconds(t[0], t[1], 0);

        if (t > time) {
          break;
        }
      }

      j = j % eventsTime[i][1].length;
      var t = eventsTime[i][1][j].split(':');

      var diff = toSeconds(t[0], t[1], 0) - time;
      if (diff < 0) {
        diff += 3600 * 24;
      }

      var h = parseInt(diff / 3600);
      diff -= 3600 * h;
      var m = parseInt(diff / 60);
      var s = diff - m * 60;

      var countdown = h + ':' + ("0" + m).slice(-2) + ':' + ("0" + s).slice(-2);



      html += '<li><table><tr style="background: transparent;"><td style="border: 0px; background: transparent;"><a href="">' + line[0] + '</a></td><td style="border: 0px; text-align: right; background: transparent;"><span>Start in ' + countdown + '</span></td></tr></table></li>';

    } else if (line.length == 3) {

      var week = [0, 0, 0, 0, 0, 0, 0];
      var weekH = [0, 0, 0, 0, 0, 0, 0];
      for (j in line[1]) {
        var t = line[2][j].split(':');
        t = toSeconds(t[0], t[1], 0);
        week[line[1][j] - 1] = t;
        weekH[line[1][j] - 1] = line[2][j];
      }

      var dd = d.getDay();
      var total = 0;
      while (1) {
        if (week[dd] && ((dd == d.getDay() && week[dd] > time) || dd != d.getDay())) {

          var w = ['', '', '', '', '', '', ''][dd];

          if (dd == d.getDay()) {
            w = '';
          }

          var diff = (dd * 24 * 60 * 60 + week[dd]) - (d.getDay() * 24 * 60 * 60 + time);

          if (diff < 0) {
            diff += 7 * 24 * 60 * 60;
          }

          var days = parseInt(diff / (24 * 60 * 60));
          diff -= days * (24 * 60 * 60);
          var h = parseInt(diff / 3600);
          diff -= 3600 * h;
          var m = parseInt(diff / 60);
          var s = diff - m * 60;

          if (days) {
            count = days + 'd ' + h + 'h';
          } else {
            var count = h + ':' + ("0" + m).slice(-2) + ':' + ("0" + s).slice(-2);
          }

          html += '<li><table><tr style="background: transparent;"><td style="border: 0px; background: transparent;"><a href="">' + line[0] + '</a></td><td style="border: 0px; text-align: right; background: transparent;"><span>Start in ' + count + '</span></td></tr></table></li>';

          break;
        }

        if (total++ > 8) {

          html += '<li><table><tr style="background: transparent;"><td style="border: 0px; background: transparent;"><a href="">' + line[0] + '</a></td><td style="border: 0px; text-align: right; background: transparent;"><span>Start in 7d</span></td></tr></table></li>';
          break;
        }
        dd = (dd + 1) % 7;
      }
    } else {
      html += '<li><table><tr style="background: transparent;"><td style="border: 0px; background: transparent;"><a href="">' + line[0] + '</a></td><td style="border: 0px; text-align: right; background: transparent;"><span>Start in ' + line[1] + '</span></td></tr></table></li>';
    }
  }
  $('#' + divId).html(html);
}
setInterval(function () {
  updateEventsTime(events, 'c_events');
  updateEventsTime(boss, 'c_boss');
}, 1000);