<?php
namespace Tests\Melbahja\Seo;

use Melbahja\Seo\Robots;

class RobotsTest extends TestCase
{

	public function testRobotsResults()
	{
		$robots = new Robots();
		$robots->bot("*", [
			'allow'    => ['/', '/dashboard/login'],
			'disallow' => ['/private', '/dashboard/'],
			'delay'    => 5
		]);

		$robots->bot("googlebot", [
			'delay' => 1
		]);

		$robots->sitemap('https://example.com/sitemaps.xml');


		$expecting = "# Autogenerated by melbahja/seo\r\nSitemap: https://example.com/sitemaps.xml\r\n\r\nUser-agent: *\r\nAllow: /\r\nAllow: /dashboard/login\r\nDisallow: /private\r\nDisallow: /dashboard/\r\nCrawl-delay: 5\r\n\r\nUser-agent: googlebot\r\nCrawl-delay: 1\r\n\r\n";

		$this->assertEquals($expecting, (string) $robots);
	}
}
