<?php
$php_version_required = '8.3';
$current_php_version = PHP_VERSION;

$requisitos = [
    'PHP 8.3' => version_compare($current_php_version, $php_version_required, '>='),
    'IonCube Loader' => extension_loaded('ionCube Loader'),
    'PDO_SQLSRV' => extension_loaded('pdo_sqlsrv'),
    'ZIP' => extension_loaded('zip'),
    'Intl' => extension_loaded('intl')
];

$erros = array_filter($requisitos, function ($status) {
    return !$status;
});

if ($_SERVER["REQUEST_METHOD"] == "POST" && empty($erros)) {
    $server = $_POST['server'];
    $port = $_POST['port'];
    $username = $_POST['username'];
    $password = $_POST['password'];
    $database = $_POST['database'];
    $team = strtolower($_POST['team']);
    $season = $_POST['season'];

    $allowed_teams = ['louis', 'igcn', 'mudevs', 'xteam', 'ssemu', 'matrix'];

    if (!in_array($team, $allowed_teams)) {
        die("<p class='error'>Time inválido!</p>");
    }

    if ($team === 'louis') {
        $allowed_seasons = ['4', '6', '8'];
        if (!in_array($season, $allowed_seasons)) {
            die("<p class='error'>Season inválida para o time LOUIS!</p>");
        }
    } elseif ($team === 'ssemu') {
        // SSEMU permite todas, então não faz validação aqui
    } else {
        // Para os demais times, se quiser pode definir uma regra geral ou remover a validação
        // Caso queira, exemplo:
        // $allowed_seasons = ['0', '1', '2', '4', '6', '8'];
    }


    try {
        $dsn = "sqlsrv:Server=$server,$port;Database=$database";
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::SQLSRV_ATTR_ENCODING => PDO::SQLSRV_ENCODING_UTF8
        ];

        $pdo = new PDO($dsn, $username, $password, $options);

        // Query SQL a ser executada
        $sql = "
/* =============================
   Tabelas de Wallet
============================= */

IF OBJECT_ID('dbo.mw_wallet_types', 'U') IS NOT NULL DROP TABLE dbo.mw_wallet_types;
CREATE TABLE mw_wallet_types (
    id INTEGER IDENTITY(1, 1) PRIMARY KEY NOT NULL,
    name VARCHAR(100) NOT NULL,
    create_date DATETIME NOT NULL DEFAULT GETDATE()
);

IF OBJECT_ID('dbo.mw_wallets', 'U') IS NOT NULL DROP TABLE dbo.mw_wallets;
CREATE TABLE mw_wallets (
    id INTEGER IDENTITY(1, 1) PRIMARY KEY NOT NULL,
    account VARCHAR(10) NOT NULL,
    wallet_type_id INTEGER NOT NULL,
    balance DECIMAL(18,2) NOT NULL DEFAULT 0
);

IF OBJECT_ID('dbo.mw_wallet_transactions', 'U') IS NOT NULL DROP TABLE dbo.mw_wallet_transactions;
CREATE TABLE mw_wallet_transactions (
    id INTEGER IDENTITY(1, 1) PRIMARY KEY NOT NULL,
    wallet_id INTEGER NOT NULL,
    description NVARCHAR(300) NULL,
    value DECIMAL(18,2) NOT NULL DEFAULT 0,
    create_date DATETIME NOT NULL DEFAULT GETDATE()
);

/* =============================
   Migração de Créditos (Se existir)
============================= */

IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MEMB_INFO' AND COLUMN_NAME = 'credits')
BEGIN
    INSERT INTO mw_wallet_types (name) VALUES (N'Créditos');
    INSERT INTO mw_wallets (account, balance, wallet_type_id) 
    SELECT memb___id, credits, 1 FROM MEMB_INFO;
    INSERT INTO mw_wallet_transactions (wallet_id, value, description) 
    SELECT id, balance, 'migration' FROM mw_wallets;
END

/* =============================
   2FA na tabela MEMB_INFO
============================= */

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID(N'dbo.MEMB_INFO') AND name = 'secret_2fa')
    ALTER TABLE MEMB_INFO ADD secret_2fa VARCHAR(200) NULL;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID(N'dbo.MEMB_INFO') AND name = 'is_2fa_enabled')
    ALTER TABLE MEMB_INFO ADD is_2fa_enabled INT NOT NULL DEFAULT 0;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID(N'dbo.MEMB_INFO') AND name = 'tfa_secret')
    ALTER TABLE MEMB_INFO ADD tfa_secret VARCHAR(200) NULL;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID(N'dbo.MEMB_INFO') AND name = 'tfa_enabled')
    ALTER TABLE MEMB_INFO ADD tfa_enabled INT NOT NULL DEFAULT 0;

/* =============================
   Tabela mw_rescues (saques)
============================= */

IF OBJECT_ID('dbo.mw_coupons_rescues', 'U') IS NOT NULL
    EXEC sp_rename 'dbo.mw_coupons_rescues', 'mw_rescues';

IF OBJECT_ID('dbo.mw_rescues', 'U') IS NULL
BEGIN
    CREATE TABLE mw_rescues (
        id INT IDENTITY(1,1) PRIMARY KEY NOT NULL,
        account VARCHAR(10) NOT NULL,
        value DECIMAL(10, 2) NOT NULL,
        tax DECIMAL(10,2) NOT NULL DEFAULT 0,
        status VARCHAR(20) NOT NULL DEFAULT 'pending',
        pix VARCHAR(100) NOT NULL,
        create_date DATETIME NOT NULL DEFAULT GETDATE(),
        wallet_type_id INT NULL
    );
END
ELSE IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('mw_rescues') AND name = 'wallet_type_id')
    ALTER TABLE mw_rescues ADD wallet_type_id INT NULL;

/* =============================
   Tabela mw_packages_categories
============================= */

IF OBJECT_ID('dbo.mw_packages_categories', 'U') IS NULL
BEGIN
    CREATE TABLE mw_packages_categories (
        id INT IDENTITY(1,1) PRIMARY KEY NOT NULL,
        name NVARCHAR(150) NOT NULL,
        description NVARCHAR(250) NULL,
        slug VARCHAR(250) NULL,
        created_at DATETIME NOT NULL DEFAULT GETDATE()
    );
END

IF OBJECT_ID('dbo.mw_sql_logs', 'U') IS NOT NULL DROP TABLE dbo.mw_sql_logs;
BEGIN
create table mw_sql_logs (
    id integer identity(1, 1) primary key not null,
    executed_at smalldatetime not null,
    duration float not null,
    sql_query text not null,
    uri text null,
    params text null,
    ip varchar(64) null,
    username varchar(10) null
);
END

IF OBJECT_ID('dbo.mw_http_logs', 'U') IS NOT NULL DROP TABLE dbo.mw_http_logs;
BEGIN
CREATE TABLE mw_http_logs (
    id integer identity(1, 1) primary key not null,
    executed_at smalldatetime not null,
    ip varchar(60) null,
    method varchar(10) null,
    uri text null,
    params text null,
    duration float null,
    username varchar(10) null
);
END

/* =============================
   Adições e Alterações Gerais
============================= */

/* mw_services */
IF EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_services') AND name = 'name')
    ALTER TABLE mw_services DROP COLUMN name;

/* mw_packages */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_packages') AND name = 'slug')
    ALTER TABLE mw_packages ADD slug NVARCHAR(200) NULL;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_packages') AND name = 'wallet_type_id')
    ALTER TABLE mw_packages ADD wallet_type_id INT NOT NULL DEFAULT 1;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_packages') AND name = 'max_sold')
    ALTER TABLE mw_packages ADD max_sold INT NULL;

/* mw_coupons */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_coupons') AND name = 'cashback_wallet_type_id')
    ALTER TABLE mw_coupons ADD cashback_wallet_type_id INT NULL;

/* mw_market_items */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_market_items') AND name = 'wallet_type_id')
    ALTER TABLE mw_market_items ADD wallet_type_id INT NULL;

IF EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_market_items') AND name = 'selling_start_date')
    ALTER TABLE mw_market_items ALTER COLUMN selling_start_date DATETIME NOT NULL;

/* mw_raffles */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_raffles') AND name = 'wallet_type_id')
    ALTER TABLE mw_raffles ADD wallet_type_id INT NOT NULL DEFAULT 1;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_raffles') AND name = 'wallets')
    ALTER TABLE mw_raffles ADD wallets VARCHAR(MAX) NULL;

/* mw_profile_block_packages */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_profile_block_packages') AND name = 'amount_wallet_value')
    ALTER TABLE mw_profile_block_packages ADD amount_wallet_value DECIMAL(18,2) NULL;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_profile_block_packages') AND name = 'amount_wallet_type_id')
    ALTER TABLE mw_profile_block_packages ADD amount_wallet_type_id INT NULL;

/* mw_shop_items */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_shop_items') AND name = 'sold')
    ALTER TABLE mw_shop_items ADD sold INT NULL;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_shop_items') AND name = 'index')
    ALTER TABLE mw_shop_items ADD [index] INT NULL;

/* mw_shop_categories */
IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_shop_categories') AND name = 'item_category')
    ALTER TABLE mw_shop_categories ADD item_category INT NULL;

IF NOT EXISTS (SELECT * FROM sys.columns WHERE object_id = OBJECT_ID('dbo.mw_shop_categories') AND name = 'icon')
    ALTER TABLE mw_shop_categories ADD icon VARCHAR(200) NULL;
    
    -- Adiciona coluna fix_durability em mw_shop_items se não existir
IF NOT EXISTS (
    SELECT * FROM sys.columns 
    WHERE object_id = OBJECT_ID('dbo.mw_shop_items') AND name = 'fix_durability'
)
BEGIN
    ALTER TABLE mw_shop_items ADD fix_durability INT NOT NULL DEFAULT -1;
END;

-- Altera a coluna selling_start_date em mw_market_items para NOT NULL (se existir)
IF EXISTS (
    SELECT * FROM sys.columns 
    WHERE object_id = OBJECT_ID('dbo.mw_market_items') AND name = 'selling_start_date'
)
BEGIN
    ALTER TABLE mw_market_items ALTER COLUMN selling_start_date DATETIME NOT NULL;
END;

-- Em seguida, altera a mesma coluna para permitir NULL (se existir)
IF EXISTS (
    SELECT * FROM sys.columns 
    WHERE object_id = OBJECT_ID('dbo.mw_market_items') AND name = 'selling_start_date'
)
BEGIN
    ALTER TABLE mw_market_items ALTER COLUMN selling_start_date DATETIME NULL;
END;

-- Adiciona a coluna slug na tabela mw_packages se não existir
IF NOT EXISTS (
    SELECT * FROM sys.columns 
    WHERE object_id = OBJECT_ID('dbo.mw_packages') AND name = 'slug'
)
BEGIN
    ALTER TABLE mw_packages ADD slug NVARCHAR(200) NULL;
END;

/* =============================
   Tabela mw_service_translations
============================= */
IF OBJECT_ID('dbo.mw_service_translations', 'U') IS NOT NULL DROP TABLE dbo.mw_service_translations;
CREATE TABLE mw_service_translations (
    id INTEGER IDENTITY(1, 1) PRIMARY KEY NOT NULL,
    name NVARCHAR(250) NOT NULL,
    service_id INTEGER NOT NULL,
    locale VARCHAR(20) NOT NULL
);

-- Limpar a tabela
DELETE FROM mw_services;

-- Inserir dados
SET IDENTITY_INSERT mw_services ON;

INSERT INTO mw_services (id, service, active, sequence, url, config_url, parent_id, allowed, rates) VALUES
(1, 'account', 1, 0, '/panel/account/info', NULL, 0, 1, NULL),
(2, 'character', 1, 1, '/panel/character', NULL, 0, 1, NULL),
(3, 'account.info', 1, 0, '/panel/account/info', NULL, 1, 1, NULL),
(4, 'account.change-pid', 1, 2, '/panel/account/change-pid', NULL, 1, 1, NULL),
(5, 'account.change-password', 1, 3, '/panel/account/change-password', NULL, 1, 1, NULL),
(6, 'account.change-email', 1, 4, '/panel/account/change-email', NULL, 1, 1, NULL),
(7, 'account.clear-vault', 1, 5, '/panel/account/clear-vault', NULL, 1, 1, NULL),
(8, 'account.repair-items', 1, 6, '/panel/account/repair-items', NULL, 1, 1, NULL),
(9, 'account.transfer-vip', 1, 7, '/panel/account/transfer-vip', '/configs/transfer-vip', 1, 1, NULL),
(10, 'character.info', 1, 0, '/info', NULL, 2, 1, NULL),
(11, 'character.move', 1, 1, '/move', '/configs/move', 2, 1, NULL),
(12, 'character.change-nick', 1, 2, '/change-nick', '/configs/change-nick', 2, 1, NULL),
(13, 'character.change-class', 1, 3, '/change-class', '/configs/change-class', 2, 1, NULL),
(14, 'character.transfer-resets', 1, 4, '/transfer-resets', '/configs/transfer-resets', 2, 1, NULL),
(15, 'character.clear-inventory', 1, 5, '/clear-inventory', NULL, 2, 1, NULL),
(16, 'character.reset', 1, 6, '/reset', '/configs/reset', 2, 1, NULL),
(17, 'character.master-reset', 1, 7, '/master-reset', '/configs/master-resets', 2, 1, NULL),
(18, 'character.redistribute-points', 1, 8, '/redistribute-points', NULL, 2, 1, NULL),
(19, 'character.rebuild-master-skill', 1, 9, '/rebuild-master-skill', '/configs/rebuild-master-skill', 2, 1, NULL),
(20, 'character.transfer-ruud', 1, 10, '/transfer-ruud', NULL, 2, 1, NULL),
(21, 'character.avatar', 1, 0, '/change-avatar', '/configs/avatar', 2, 1, NULL),
(22, 'purchases', 1, 0, '/panel/purchases', NULL, 0, 1, NULL),
(23, 'purchases.confirmation', 1, 0, '/orders/payment-confirmations', NULL, 22, 1, NULL),
(24, 'support.tickets', 1, 0, '/support/tickets', '/helpdesk/config', 0, 1, NULL),
(25, 'purchases.market', 1, 0, '/market/items/purchases', NULL, 22, 1, NULL),
(26, 'credit-shop', 1, 0, '/packages', '/packages', 0, 1, NULL),
(27, 'character.block-profile', 1, 0, '/block-profile', '/configs/profiles', 2, 1, NULL),
(28, 'purchases.webshop', 1, 0, '/shop/purchases', NULL, 22, 1, NULL),
(29, 'workshop', 1, 0, '/workshop', NULL, 0, 1, NULL);

-- Desligar IDENTITY_INSERT
SET IDENTITY_INSERT mw_services OFF;

SET IDENTITY_INSERT mw_service_translations ON;

INSERT INTO mw_service_translations (id, name, service_id, locale) VALUES
(1, N'Minha Conta', 1, 'pt_BR'),
(2, N'Mi Cuenta', 1, 'es_ES'),
(3, N'マイアカウント', 1, 'ja_JP'),
(4, N'Мой аккаунт', 1, 'ru_RU'),
(5, N'Tài khoản của tôi', 1, 'vi_VN'),
(6, N'我的帳戶', 1, 'zh_TW'),

(7, N'Meus Personagens', 2, 'pt_BR'),
(8, N'Mis Personajes', 2, 'es_ES'),
(9, N'私のキャラクター', 2, 'ja_JP'),
(10, N'Мои персонажи', 2, 'ru_RU'),
(11, N'Nhân vật của tôi', 2, 'vi_VN'),
(12, N'我的角色', 2, 'zh_TW'),

(13, N'Informações', 3, 'pt_BR'),
(14, N'Información', 3, 'es_ES'),
(15, N'情報', 3, 'ja_JP'),
(16, N'Информация', 3, 'ru_RU'),
(17, N'Thông tin', 3, 'vi_VN'),
(18, N'資訊', 3, 'zh_TW'),

(19, N'Alterar PID', 4, 'pt_BR'),
(20, N'Cambiar PID', 4, 'es_ES'),
(21, N'PIDを変更する', 4, 'ja_JP'),
(22, N'Изменить PID', 4, 'ru_RU'),
(23, N'Thay đổi PID', 4, 'vi_VN'),
(24, N'更改PID', 4, 'zh_TW'),

(25, N'Alterar Senha', 5, 'pt_BR'),
(26, N'Cambiar Contraseña', 5, 'es_ES'),
(27, N'パスワードを変更', 5, 'ja_JP'),
(28, N'Сменить пароль', 5, 'ru_RU'),
(29, N'Đổi mật khẩu', 5, 'vi_VN'),
(30, N'更改密碼', 5, 'zh_TW'),

(31, N'Alterar E-mail', 6, 'pt_BR'),
(32, N'Cambiar Correo Electrónico', 6, 'es_ES'),
(33, N'メールを変更', 6, 'ja_JP'),
(34, N'Изменить Email', 6, 'ru_RU'),
(35, N'Thay đổi Email', 6, 'vi_VN'),
(36, N'更改電子郵件', 6, 'zh_TW'),

(37, N'Limpar Baú', 7, 'pt_BR'),
(38, N'Limpiar Baúl', 7, 'es_ES'),
(39, N'倉庫をクリア', 7, 'ja_JP'),
(40, N'Очистить хранилище', 7, 'ru_RU'),
(41, N'Xóa rương', 7, 'vi_VN'),
(42, N'清空倉庫', 7, 'zh_TW'),

(43, N'Consertar Items', 8, 'pt_BR'),
(44, N'Reparar Items', 8, 'es_ES'),
(45, N'アイテムを修理', 8, 'ja_JP'),
(46, N'Починить предметы', 8, 'ru_RU'),
(47, N'Sửa vật phẩm', 8, 'vi_VN'),
(48, N'修理物品', 8, 'zh_TW'),

(49, N'Transferir VIP', 9, 'pt_BR'),
(50, N'Transferir VIP', 9, 'es_ES'),
(51, N'VIPを転送', 9, 'ja_JP'),
(52, N'Перенести VIP', 9, 'ru_RU'),
(53, N'Chuyển VIP', 9, 'vi_VN'),
(54, N'轉移VIP', 9, 'zh_TW'),

(55, N'Informações', 10, 'pt_BR'),
(56, N'Información', 10, 'es_ES'),
(57, N'情報', 10, 'ja_JP'),
(58, N'Информация', 10, 'ru_RU'),
(59, N'Thông tin', 10, 'vi_VN'),
(60, N'資訊', 10, 'zh_TW'),

(61, N'Mover', 11, 'pt_BR'),
(62, N'Mover', 11, 'es_ES'),
(63, N'移動', 11, 'ja_JP'),
(64, N'Переместить', 11, 'ru_RU'),
(65, N'Di chuyển', 11, 'vi_VN'),
(66, N'移動', 11, 'zh_TW'),

(67, N'Alterar Nickname', 12, 'pt_BR'),
(68, N'Cambiar Apodo', 12, 'es_ES'),
(69, N'ニックネームを変更', 12, 'ja_JP'),
(70, N'Изменить никнейм', 12, 'ru_RU'),
(71, N'Thay đổi biệt danh', 12, 'vi_VN'),
(72, N'更改暱稱', 12, 'zh_TW'),

(73, N'Alterar Classe', 13, 'pt_BR'),
(74, N'Cambiar Clase', 13, 'es_ES'),
(75, N'クラスを変更する', 13, 'ja_JP'),
(76, N'Сменить класс', 13, 'ru_RU'),
(77, N'Thay đổi lớp', 13, 'vi_VN'),
(78, N'更改職業', 13, 'zh_TW'),

(79, N'Transferir Resets', 14, 'pt_BR'),
(80, N'Transferir Resets', 14, 'es_ES'),
(81, N'リセットを転送', 14, 'ja_JP'),
(82, N'Перенести ресеты', 14, 'ru_RU'),
(83, N'Chuyển Resets', 14, 'vi_VN'),
(84, N'轉移重置', 14, 'zh_TW'),

(85, N'Limpar Inventário', 15, 'pt_BR'),
(86, N'Limpiar Inventario', 15, 'es_ES'),
(87, N'インベントリをクリア', 15, 'ja_JP'),
(88, N'Очистить инвентарь', 15, 'ru_RU'),
(89, N'Xóa hành trang', 15, 'vi_VN'),
(90, N'清空背包', 15, 'zh_TW'),

(91, N'Resetar', 16, 'pt_BR'),
(92, N'Resetear', 16, 'es_ES'),
(93, N'リセットする', 16, 'ja_JP'),
(94, N'Сбросить', 16, 'ru_RU'),
(95, N'Đặt lại', 16, 'vi_VN'),
(96, N'重置', 16, 'zh_TW'),

(97, N'Master Reset', 17, 'pt_BR'),
(98, N'Master Reset', 17, 'es_ES'),
(99, N'マスターリセット', 17, 'ja_JP'),
(100, N'Мастер ресет', 17, 'ru_RU'),
(101, N'Master Reset', 17, 'vi_VN'),
(102, N'主重置', 17, 'zh_TW'),

(103, N'Redistribuir ponto', 18, 'pt_BR'),
(104, N'Redistribuir puntos', 18, 'es_ES'),
(105, N'ポイントを再分配', 18, 'ja_JP'),
(106, N'Распределить очки', 18, 'ru_RU'),
(107, N'Phân phối lại điểm', 18, 'vi_VN'),
(108, N'重新分配點數', 18, 'zh_TW'),

(109, N'Rebuild Master Skill', 19, 'pt_BR'),
(110, N'Reconstruir Master Skill', 19, 'es_ES'),
(111, N'マスタースキルを再構築', 19, 'ja_JP'),
(112, N'Перестроить мастерство', 19, 'ru_RU'),
(113, N'Xây dựng lại Master Skill', 19, 'vi_VN'),
(114, N'重建大師技能', 19, 'zh_TW'),

(115, N'Transferir Ruud', 20, 'pt_BR'),
(116, N'Transferir Ruud', 20, 'es_ES'),
(117, N'ルードを転送', 20, 'ja_JP'),
(118, N'Перенести Ruud', 20, 'ru_RU'),
(119, N'Chuyển Ruud', 20, 'vi_VN'),
(120, N'轉移 Ruud', 20, 'zh_TW'),

(121, N'Cambiar avatar', 21, 'es_ES'),
(122, N'アバターを変更', 21, 'ja_JP'),
(123, N'Alterar Avatar', 21, 'pt_BR'),
(124, N'Изменить аватар', 21, 'ru_RU'),
(125, N'Thay đổi Avatar', 21, 'vi_VN'),
(126, N'更換頭像', 21, 'zh_TW'),
(127, N'Change Avatar', 21, 'en_US'),

(128, N'Mis compras', 22, 'es_ES'),
(129, N'購入履歴', 22, 'ja_JP'),
(130, N'Minhas Compras', 22, 'pt_BR'),
(131, N'Мои покупки', 22, 'ru_RU'),
(132, N'Mua hàng của tôi', 22, 'vi_VN'),
(133, N'我的購買', 22, 'zh_TW'),
(134, N'My Purchases', 22, 'en_US'),

(135, N'Confirmación de pago', 23, 'es_ES'),
(136, N'支払い確認', 23, 'ja_JP'),
(137, N'Confirmação de Pagamento', 23, 'pt_BR'),
(138, N'Подтверждение оплаты', 23, 'ru_RU'),
(139, N'Xác nhận thanh toán', 23, 'vi_VN'),
(140, N'付款確認', 23, 'zh_TW'),
(141, N'Payment Confirmation', 23, 'en_US'),

(142, N'Tickets de soporte', 24, 'es_ES'),
(143, N'サポートチケット', 24, 'ja_JP'),
(144, N'Tickets de Suporte', 24, 'pt_BR'),
(145, N'Поддержка тикетов', 24, 'ru_RU'),
(146, N'Ve hỗ trợ', 24, 'vi_VN'),
(147, N'支援票', 24, 'zh_TW'),
(148, N'Support Tickets', 24, 'en_US'),

(149, N'Compras en el mercado', 25, 'es_ES'),
(150, N'市場での買い物', 25, 'ja_JP'),
(151, N'Compras no Market', 25, 'pt_BR'),
(152, N'Покупки на рынке', 25, 'ru_RU'),
(153, N'Mua sắm tại Chợ', 25, 'vi_VN'),
(154, N'市場購物', 25, 'zh_TW'),
(155, N'Purchases Market', 25, 'en_US'),

(156, N'Tienda de crédito', 26, 'es_ES'),
(157, N'クレジットストア', 26, 'ja_JP'),
(158, N'Loja de Créditos', 26, 'pt_BR'),
(159, N'Кредитный магазин', 26, 'ru_RU'),
(160, N'Cửa hàng tín dụng', 26, 'vi_VN'),
(161, N'信用商店', 26, 'zh_TW'),
(162, N'Credit Shop', 26, 'en_US'),

(163, N'Bloqueo de perfil', 27, 'es_ES'),
(164, N'プロフィールロック', 27, 'ja_JP'),
(165, N'Bloqueio de Perfil', 27, 'pt_BR'),
(166, N'Блокировка профиля', 27, 'ru_RU'),
(167, N'Khóa hồ sơ', 27, 'vi_VN'),
(168, N'個人資料鎖定', 27, 'zh_TW'),
(169, N'Block Profile', 27, 'en_US'),

(170, N'Compras en la tienda web', 28, 'es_ES'),
(171, N'ウェブショップでの購入', 28, 'ja_JP'),
(172, N'Compras WebShop', 28, 'pt_BR'),
(173, N'Покупки в интернет-магазине', 28, 'ru_RU'),
(174, N'Mua hàng trên WebShop', 28, 'vi_VN'),
(175, N'網上商店購買', 28, 'zh_TW'),
(176, N'Purchases Webshop', 28, 'en_US'),

(177, N'Taller', 29, 'es_ES'),
(178, N'ワークショップ', 29, 'ja_JP'),
(179, N'WorkShop', 29, 'pt_BR'),
(180, N'Мастерская', 29, 'ru_RU'),
(181, N'Xưởng', 29, 'vi_VN'),
(182, N'工作坊', 29, 'zh_TW'),
(183, N'WorkShop', 29, 'en_US');
SET IDENTITY_INSERT mw_service_translations OFF;

        ";

        $pdo->exec($sql);

        $update_sql = "
            UPDATE [dbo].[mw_config]
            SET [body] = REPLACE(
                            REPLACE(
                                [body], 
                                SUBSTRING(
                                    [body], 
                                    CHARINDEX('\"team\":\"', [body]) + 8, 
                                    CHARINDEX('\"', [body], CHARINDEX('\"team\":\"', [body]) + 8) - CHARINDEX('\"team\":\"', [body]) - 8
                                ),
                                ?), 
                            SUBSTRING(
                                [body], 
                                CHARINDEX('\"season\":\"', [body]) + 10, 
                                CHARINDEX('\"', [body], CHARINDEX('\"season\":\"', [body]) + 10) - CHARINDEX('\"season\":\"', [body]) - 10
                            ), 
                            ?
                        )
            WHERE [config] = 'server';
        ";
            
        $stmt = $pdo->prepare($update_sql);
        $stmt->execute([$team, $season]);

        $pdo->exec($sql);
                
        $mensagem = "<p class='success'><center>Migração concluída com sucesso!</center></p>";
        
        echo "
            <script type='text/javascript'>
                alert('$mensagem');
            </script>
        ";
            } catch (PDOException $e) {
            die("<p class='error'>Erro na migração:<br/> " . $e->getMessage() . "</p>");
        }
        
        }
    include 'migration.phtml';
?>