function calculatePrice() {
    const priceInput = document.getElementById('item-price');
    const levelInput = document.getElementById('item-level');
    const optionInput = document.getElementById('item-option');
    const skillInput = document.getElementById('item-skill');
    const luckInput = document.getElementById('item-luck');
    const ancientInput = document.getElementById('item-ancient');
    const harmonyInput = document.getElementById('item-harmony');
    const refineInput = document.getElementById('item-refine');
    const elementInput = document.getElementById('item-element');
    const couponInput = document.getElementById('item-coupon');

    let price = Number(priceInput.dataset.price);

    if (levelInput !== null) {
        price += Number(levelInput.value * levelInput.dataset.price);
    }
    if (optionInput !== null) {
        price += Number(optionInput.value * optionInput.dataset.price);
    }
    if (skillInput !== null && skillInput.checked) {
        price += Number(skillInput.dataset.price);
    }
    if (luckInput !== null && luckInput.checked) {
        price += Number(luckInput.dataset.price);
    }
    if (ancientInput !== null && ancientInput.value > 0) {
        price += Number(ancientInput.dataset.price);
    }

    for (let i = 0; i <= 5; i++) {
        const excellentInput = document.getElementById(`excellent-${i}`);
        if (excellentInput !== null && excellentInput.checked) {
            price += Number(excellentInput.dataset.price);
        }
    }

    if (refineInput !== null && refineInput.checked) {
        price += Number(refineInput.dataset.price);
    }

    if (harmonyInput !== null && harmonyInput.value !== '') {
        price += Number(harmonyInput.dataset.price);
    }

    if (elementInput !== null && elementInput.value !== '') {
        price += Number(elementInput.dataset.price);
    }

    for (let i = 0; i <= 4; i++) {
        const pentagramInput = document.getElementById(`pentagram-${i}`);
        if (pentagramInput !== null && pentagramInput.checked) {
            price += Number(pentagramInput.dataset.price);
        }
    }

    for (let i = 0; i <= 4; i++) {
        const errtelInput = document.getElementById(`errtel-option-${i}`);
        if (errtelInput !== null && Number(errtelInput.value) !== -2) {
            price += Number(errtelInput.dataset.price);
        }
    }

    for (let i = 0; i <= 4; i++) {
        const socketInput = document.getElementById(`socket-${i}`);
        if (socketInput !== null && socketInput.value !== '-2') {
            const socketPrice = socketInput.dataset.price
            const selected = socketInput.options[socketInput.selectedIndex]
            const level = selected.dataset.level

            if (socketPrice.includes('|')) {
                const prices = socketPrice.split('|')
                let index = level + 1
                if (prices.length < index) {
                    index = prices.length
                }

                if (socketInput.value === '-1') {
                    price += Number(prices[0]);
                } else {
                    price += Number(prices[index]);
                }
            } else {
                price += Number(socketPrice);
            }
        }
    }

    if (couponInput !== null && couponInput.dataset?.discount) {
        price -= Number(price * couponInput.dataset.discount / 100);
    }

    priceInput.innerHTML = Math.floor(price);
}

DOMLoaded(function () {
    document.querySelectorAll('[data-price]').forEach(element => element.addEventListener('input', calculatePrice));

    const webshopProductCoupon = document.getElementById('item-coupon');
    if (webshopProductCoupon) {
        webshopProductCoupon.addEventListener('change', async (e) => {
            webshopProductCoupon.dataset.discount = 0;

            if (webshopProductCoupon.value !== '') {
                const response = await fetch(`${window.Morpheus.basePath}coupons/${webshopProductCoupon.value}/webshop`);
                const data = await response.json();

                if (data.success) {
                    webshopProductCoupon.dataset.discount = data.data.discount;
                    window.Morpheus.dialog.success(data.message);
                } else {
                    webshopProductCoupon.value = ''
                    window.Morpheus.dialog.error(data.message);
                }
            }

            calculatePrice();
        });
    }
});