DOMLoaded(() => {

    const inputs = document.querySelectorAll(".workshop [data-default]");
    inputs.forEach(el => {
        el.addEventListener('change', e => {
            const levelInput = document.getElementById("item-level");
            const optionInput = document.getElementById("item-option");
            const skillInput = document.getElementById("item-skill");
            const luckInput = document.getElementById("item-luck");
            const ancientInput = document.getElementById("item-ancient");
            const harmonyInput = document.getElementById("item-harmony");
            const refineInput = document.getElementById("item-refine");
            const mastery = document.getElementById("item-mastery-bonus");
            const elementInput = document.getElementById("item-element");
            const prices = {};

            const initialPrices = JSON.parse(levelInput.dataset.prices);
            for (let price in initialPrices) {
                prices[price] = 0;
            }

            if (levelInput !== null) {
                const level = Number(levelInput.value);
                const currentLevel = Number(levelInput.dataset.default);
                if (level !== currentLevel) {
                    const pricesLevel = JSON.parse(levelInput.dataset.prices);

                    for (const coin in pricesLevel) {
                        const price = pricesLevel[coin];

                        if (typeof (price) === 'object') {
                            const lastPrice = parseInt(price[Object.keys(price)[Object.keys(price).length - 1]], 10);
                            if (level < currentLevel) {
                                for (let i = level; i <= currentLevel - 1; i++) {
                                    prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                                }
                            } else {
                                for (let i = currentLevel + 1; i <= level; i++) {
                                    prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                                }
                            }
                        } else {
                            prices[coin] += Math.abs(level - currentLevel) * price;
                        }
                    }
                }
            }

            if (optionInput !== null) {
                const option = Number(optionInput.value);
                const currentOption = Number(optionInput.dataset.default);
                if (option !== currentOption) {
                    const pricesOption = JSON.parse(optionInput.dataset.prices);

                    for (const coin in pricesOption) {
                        let price = pricesOption[coin];

                        if (typeof (price) === 'object') {
                            const lastPrice = parseInt(price[Object.keys(price)[Object.keys(price).length - 1]], 10);

                            if (option < currentOption) {
                                for (let i = option; i <= currentOption - 4; i += 4) {
                                    prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                                }
                            } else {
                                for (let i = currentOption + 4; i <= option; i += 4) {
                                    prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                                }
                            }
                        } else {
                            prices[coin] += Math.abs(option - currentOption) * price;
                        }
                    }
                }
            }

            if (luckInput !== null && Number(luckInput.checked) !== Number(luckInput.dataset.default)) {
                const price = JSON.parse(luckInput.dataset.prices);
                for (const coin in price) {
                    prices[coin] += parseInt(price[coin], 10);
                }
            }

            if (skillInput !== null && Number(skillInput.checked) !== Number(skillInput.dataset.default)) {
                const price = JSON.parse(skillInput.dataset.prices);
                for (const coin in price) {
                    prices[coin] += parseInt(price[coin], 10);
                }
            }

            if (ancientInput !== null && ancientInput.value !== ancientInput.dataset.default) {
                const price = JSON.parse(ancientInput.dataset.prices);
                for (const coin in price) {
                    prices[coin] += parseInt(price[coin], 10);
                }
            }

            let pricesExcellent = null;
            let upgradeExcellentCount = 0;
            let downgradeExcellentCount = 0;
            let countTotalExcellent = 0;
            for (let i = 0; i <= 5; i++) {
                const excellentInput = document.getElementById(`excellent-${i}`);
                if (excellentInput !== null) {
                    if (excellentInput.checked) {
                        countTotalExcellent++;
                    }

                    if (Number(excellentInput.checked) !== Number(excellentInput.dataset.default)) {
                        pricesExcellent = JSON.parse(excellentInput.dataset.prices);

                        for (let coin in pricesExcellent) {
                            let price = pricesExcellent[coin];

                            if (typeof(price) !== 'object') {
                                prices[coin] += parseInt(price, 10);
                            } else {
                                if (excellentInput.checked) {
                                    upgradeExcellentCount++;
                                } else {
                                    downgradeExcellentCount++;
                                }
                                break;
                            }
                        }
                    }
                }
            }

            if (upgradeExcellentCount > 0 || downgradeExcellentCount > 0) {
                for (const coin in pricesExcellent) {
                    const price = pricesExcellent[coin];

                    prices[coin] += Number(price['remove']) * downgradeExcellentCount;

                    for (let i = (countTotalExcellent - upgradeExcellentCount); i < countTotalExcellent; i++) {
                        prices[coin] += parseInt(price['add'][i], 10);
                    }
                }
            }

            let pricesSocket = null;
            let upgradeSocketCount = 0;
            let downgradeSocketCount = 0;
            let countTotalSocket = 0;
            for (let i = 0; i < 5; i++) {
                const socketInput = document.getElementById(`item-socket-${i}`);
                if (socketInput !== null) {
                    const socket = Number(socketInput.value);

                    if (socket !== -2) {
                        countTotalSocket++;
                    }

                    const currentSocket = Number(socketInput.dataset.default);
                    if (socket !== currentSocket) {
                        pricesSocket = JSON.parse(socketInput.dataset.prices);

                        for (const coin in pricesSocket) {
                            const price = pricesSocket[coin];

                            if (typeof(price) !== 'object') {
                                prices[coin] += parseInt(price, 10);
                            } else {
                                if (socket !== -2) {
                                    upgradeSocketCount++;
                                } else {
                                    downgradeSocketCount++;
                                }
                                break;
                            }
                        }
                    }
                }
            }

            if (upgradeSocketCount > 0 || downgradeSocketCount > 0) {
                for (let coin in pricesSocket) {
                    let price = pricesSocket[coin];
                    prices[coin] += Number(price['remove']) * downgradeSocketCount;

                    for (let i = Math.abs(countTotalSocket - upgradeSocketCount); i < countTotalSocket; i++) {
                        prices[coin] += Number(price['add'][i]);
                    }
                }
            }

            if (refineInput !== null && Number(refineInput.checked) !== Number(refineInput.dataset.default)) {
                const price = JSON.parse(refineInput.dataset.prices);
                for (const coin in price) {
                    prices[coin] += parseInt(price[coin], 10);
                }
            }

            if (harmonyInput !== null && harmonyInput.value !== harmonyInput.dataset.default) {
                const price = JSON.parse(harmonyInput.dataset.prices);
                for (const coin in price) {
                    prices[coin] += parseInt(price[coin], 10);
                }
            }

            if (elementInput !== null && Number(elementInput.value) !== Number(elementInput.dataset.default)) {
                const price = JSON.parse(elementInput.dataset.prices);
                for (const coin in price) {
                    prices[coin] += parseInt(price[coin], 10);
                }
            }

            let pricesPentagram = null;
            let upgradePentagramCount = 0;
            let downgradePentagramCount = 0;
            let countTotalPentagram = 0;
            for (let i = 0; i <= 5; i++) {
                const pentagramInput = document.getElementById(`item-pentagram-${i}`);
                if (pentagramInput !== null) {
                    const pentagram = Number(pentagramInput.value);

                    if (pentagram !== -2) {
                        countTotalPentagram++;
                    }

                    if (pentagram !== Number(pentagramInput.dataset.default)) {
                        pricesPentagram = JSON.parse(pentagramInput.dataset.prices);

                        for (let coin in pricesPentagram) {
                            let price = pricesPentagram[coin];

                            if (typeof(price) !== 'object') {
                                prices[coin] += parseInt(price, 10);
                            } else {
                                if (pentagram !== -2) {
                                    upgradePentagramCount++;
                                } else {
                                    downgradePentagramCount++;
                                }
                                break;
                            }
                        }
                    }
                }
            }

            if (upgradePentagramCount > 0 || downgradePentagramCount > 0) {
                for (const coin in pricesPentagram) {
                    const price = pricesPentagram[coin];

                    prices[coin] += Number(price['remove']) * downgradePentagramCount;

                    for (let i = (countTotalPentagram - upgradePentagramCount); i < countTotalPentagram; i++) {
                        prices[coin] += parseInt(price['add'][i], 10);
                    }
                }
            }

            let pricesErrtel = null;
            let upgradeErrtelCount = 0;
            let downgradeErrtelCount = 0;
            let countTotalErrtel = 0;
            for (let i = 0; i < 5; i++) {
                const errtelOptionInput = document.getElementById(`item-errtel-option-${i}`);
                const errtelLevelInput = document.getElementById(`item-errtel-level-${i}`);

                if (errtelOptionInput !== null) {
                    const errtel = Number(errtelOptionInput.value);

                    if (errtel !== -2) {
                        countTotalErrtel++;
                    }

                    if (errtel !== Number(errtelOptionInput.dataset.default)) {
                        pricesErrtel = JSON.parse(errtelOptionInput.dataset.prices);

                        for (let coin in pricesErrtel) {
                            let price = pricesErrtel[coin];

                            if (typeof(price) !== 'object') {
                                prices[coin] += parseInt(price, 10);
                            } else {
                                if (errtel !== -2) {
                                    upgradeErrtelCount++;
                                } else {
                                    downgradeErrtelCount++;
                                }
                                break;
                            }
                        }
                    }
                }

                if (errtelLevelInput !== null) {
                    const level = Number(errtelLevelInput.value);
                    const currentLevel = Number(errtelLevelInput.dataset.default);
                    if (level !== currentLevel) {
                        const pricesLevel = JSON.parse(errtelLevelInput.dataset.prices);

                        for (const coin in pricesLevel) {
                            const price = pricesLevel[coin];

                            if (typeof (price) === 'object') {
                                const lastPrice = parseInt(price[Object.keys(price)[Object.keys(price).length - 1]], 10);
                                if (level < currentLevel) {
                                    for (let i = level; i <= currentLevel - 1; i++) {
                                        prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                                    }
                                } else {
                                    for (let i = currentLevel + 1; i <= level; i++) {
                                        prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                                    }
                                }
                            } else {
                                prices[coin] += Math.abs(level - currentLevel) * price;
                            }
                        }
                    }
                }
            }

            if (upgradeErrtelCount > 0 || downgradeErrtelCount > 0) {
                for (const coin in pricesErrtel) {
                    const price = pricesErrtel[coin];

                    prices[coin] += Number(price['remove']) * downgradeErrtelCount;

                    for (let i = (countTotalErrtel - upgradeErrtelCount); i < countTotalErrtel; i++) {
                        prices[coin] += parseInt(price['add'][i], 10);
                    }
                }
            }

            // if (masteryInput !== null && masteryInput.value !== masteryInput.dataset.default) {
            //     const price = parseJson(masteryInput.dataset.prices);
            //     for (const coin in price) {
            //         prices[coin] += parseInt(price[coin], 10);
            //     }
            // }

            // pricesContainer.show();

            for (const coin in prices) {
                document.getElementById(`total-${coin}`).innerText = prices[coin];
            }
        });
    });

    const changeWarehouse = document.querySelector('[data-workshop-change-warehouse]');
    changeWarehouse?.addEventListener('change', () => {
        window.location = `${window.Morpheus.basePath}workshop/warehouse/${changeWarehouse.value}`;
    })
});