$(function () {

    $.getJSON($.morpheus.base_path + "ajax/streamers/online", function (data) {

        var html = '';
        for (var i = 0; i < data.onlines.length; i++) {
            var stream = data.onlines[i];

            html += ['<a class="streamers__streamer" href="' + stream.link + '" target="_blank" title="' + stream.title + '">',
                '<div class="streamers__streamer-name">' + stream.name + '</div>',
                '<div class="streamers__streamer-thumb">',
                '<img src="' + stream.thumbnail_url.replace('{width}', 100).replace('{height}', 80) + '">',
                '<div class="streamers__streamer-thumb-user">',
                '<img src="' + stream.profile_image_url + '" height="40">',
                '</div>',
                '</div>',
                '</a>'].join('');
        }

        if (html !== '') {
            $("[data-streamers-online]").html(html);

            setTimeout(function () {
                var $container = $("[data-streamers]");
                var width = $container.width();

                $container.css('display', 'flex').css('right', '-' + width + 'px');
                $container.animate({
                    right: 0
                }, 1000);
            }, 100);

        }
    });

    $(document).on("click", "[data-toggle-streamers]", function (e) {
        var $container = $("[data-streamers]");
        var width = $("[data-streamers-online]").width();
        var right = $container.css('right');

        if (right === '0px') {
            $container.animate({
                right: '-' + width + 'px'
            }, 1000);
        } else {
            $container.animate({
                right: 0
            }, 1000);
        }

        e.preventDefault();
    });

});