$(function () {
    function parseJson(json) {
        json = json.replace(/'/g, '"');

        return JSON.parse(json);
    }

    $(document).on("change", "#workshop-item :input", function () {
        var $price = $("#upgrade-price");
        var $level = $("#item-level");
        var $option = $("#item-option");
        var $skill = $("#item-skill");
        var $luck = $("#item-luck");
        var $ancient = $("#item-ancient");
        var $harmony = $("#item-harmony");
        var $refine = $("#item-refine");
        var $sockets = $("[id^=item-socket-]");
        var $excellent = $("[id^=item-excellent-]");
        var $mastery = $("#item-mastery-bonus");

        var $pricec = $(".workshop-upgrade-price");

        var prices = {};

        const initialPrices = parseJson($level.data("prices"));
        for (let p in initialPrices) {
            prices[p] = 0;
        }

        let level = Number($level.val());
        const currentLevel = Number($level.data("default"));
        if (level !== currentLevel) {
            // if (level === 0) {
            //     level = 1;
            // }
            const pricesLevel = parseJson($level.data("prices"));

            for (let coin in pricesLevel) {
                const price = pricesLevel[coin];

                if (typeof(price) === 'object') {
                    const lastPrice = parseInt(price[Object.keys(price)[Object.keys(price).length - 1]], 10);
                    if (level < currentLevel) {
                        for (let i = level; i <= currentLevel -1; i++) {
                            prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                        }
                    } else {
                        for (let i = currentLevel + 1; i <= level; i++) {
                            prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                        }
                    }
                } else {
                    prices[coin] += parseInt(Math.abs(level - currentLevel) * price, 10);
                }
            }
        }

        let option = Number($option.val());
        const currentOption = Number($option.data("default"));
        if (option !== currentOption) {
            // if (option === 0) {
            //     option = 4;
            // }
            const pricesOption = parseJson($option.data("prices"));

            for (let coin in pricesOption) {
                let price = pricesOption[coin];

                if (typeof(price) === 'object') {
                    const lastPrice = parseInt(price[Object.keys(price)[Object.keys(price).length - 1]], 10);

                    if (option < currentOption) {
                        for (let i = option; i <= currentOption -4; i+=4) {
                            prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                        }
                    } else {
                        for (let i = currentOption + 4; i <= option; i+=4) {
                            prices[coin] += parseInt(price[i] === undefined ? lastPrice : price[i], 10);
                        }
                    }
                } else {
                    prices[p] += parseInt(Math.abs(option - currentOption) * price, 10);
                }
            }
        }

        if ($luck.size() > 0 && $luck.is(":checked") != $luck.data("default")) {
            var prcs = parseJson($luck.data("prices"));
            for (var prc in prcs) {
                prices[prc] += parseInt(prcs[prc], 10);
            }
        }

        if ($skill.size() > 0 && $skill.is(":checked") != $skill.data("default")) {
            var prcs = parseJson($skill.data("prices"));
            for (var prc in prcs) {
                prices[prc] += parseInt(prcs[prc], 10);
            }
        }

        if ($ancient.size() > 0 && $ancient.val() != $ancient.data("default")) {
            var prcs = parseJson($ancient.data("prices"));
            for (var prc in prcs) {
                prices[prc] += parseInt(prcs[prc], 10);
            }
        }

        let pricesExcellent = null;
        let upgradeExcellentCount = 0;
        let downgradeExcellentCount = 0;
        for (let i = 0; i < $excellent.size(); i++) {
            const $exc = $excellent.eq(i);

            if ($exc.is(":checked") !== Boolean($exc.data("default"))) {
                pricesExcellent = parseJson($exc.data("prices"));

                for (let coin in pricesExcellent) {
                    let price = pricesExcellent[coin];

                    if (typeof(price) !== 'object') {
                        prices[coin] += parseInt(price, 10);
                    } else {
                        if ($exc.is(":checked")) {
                            upgradeExcellentCount++;
                        } else {
                            downgradeExcellentCount++;
                        }
                        break;
                    }
                }
            }
        }

        let countTotalExcellent = 0;
        for (let i = 0; i < $excellent.size(); i++) {
            const $exc = $excellent.eq(i);
            if ($exc.is(":checked")) {
                countTotalExcellent++;
            }
        }

        if (upgradeExcellentCount > 0 || downgradeExcellentCount > 0) {
            for (let coin in pricesExcellent) {
                let price = pricesExcellent[coin];

                prices[coin] += Number(price['remove']) * downgradeExcellentCount;

                for (let i = (countTotalExcellent - upgradeExcellentCount); i < countTotalExcellent; i++) {
                    prices[coin] += parseInt(price['add'][i], 10);
                }
            }
        }

        let pricesSocket = null;
        let upgradeSocketCount = 0;
        let downgradeSocketCount = 0;
        for (let i = 0; i < $sockets.size(); i++) {
            const $sock = $sockets.eq(i);
            const socket = Number($sock.val());
            const currentSocket = Number($sock.data("default"));

            if (socket !== currentSocket) {
                pricesSocket = parseJson($sock.data("prices"));

                for (let coin in pricesSocket) {
                    let price = pricesSocket[coin];

                    if (typeof(price) !== 'object') {
                        prices[coin] += parseInt(price, 10);
                    } else {
                        if (socket !== -2) {
                            upgradeSocketCount++;
                        } else {
                            downgradeSocketCount++;
                        }
                        break;
                    }
                }
            }
        }

        let totalSocketCount = 0;
        for (let i = 0; i < $sockets.size(); i++) {
            const $sock = $sockets.eq(i);
            const socket = Number($sock.val());

            if (socket !== -2) {
                totalSocketCount++;
            }
        }

        if (upgradeSocketCount > 0 || downgradeSocketCount > 0) {
            for (let coin in pricesSocket) {
                let price = pricesSocket[coin];

                prices[coin] += Number(price['remove']) * downgradeSocketCount;

                for (let i = (totalSocketCount - upgradeSocketCount); i < totalSocketCount; i++) {
                    prices[coin] += parseInt(price['add'][i], 10);
                }
            }
        }

        if ($refine.size() > 0 && $refine.is(":checked") != $refine.data("default")) {
            var prcs = parseJson($refine.data("prices"));
            for (var prc in prcs) {
                prices[prc] += parseInt(prcs[prc], 10);
            }
        }

        if ($harmony.size() > 0 && $harmony.val() != $harmony.data("default")) {
            var prcs = parseJson($harmony.data("prices"));
            for (var prc in prcs) {
                prices[prc] += parseInt(prcs[prc], 10);
            }
        }

        if ($mastery.size() > 0 && $mastery.val() != $mastery.data("default")) {
            var prcs = parseJson($mastery.data("prices"));
            for (var prc in prcs) {
                prices[prc] += parseInt(prcs[prc], 10);
            }
        }

        $pricec.show();

        for (var coin in prices) {
            $("#total-" + coin).text(prices[coin]);
        }
    });

});