IF OBJECT_ID('dbo.mw_banned_accounts', 'U') IS NOT NULL DROP TABLE dbo.mw_banned_accounts;
create table mw_banned_accounts (
    id integer identity(1, 1) primary key not null,
    account varchar(10) not null,
    cause nvarchar(MAX) collate Latin1_General_CI_AS null,
    notes nvarchar(MAX) collate Latin1_General_CI_AS null,
    block_date datetime default getdate() not null,
    unblock_date datetime null,
    user_block_id integer null,
    status integer default 1 not null
);

IF OBJECT_ID('dbo.mw_config', 'U') IS NOT NULL DROP TABLE dbo.mw_config;
create table mw_config (
    id integer identity(1, 1) primary key not null,
    config varchar(400) not null,
    body nvarchar(MAX) collate Latin1_General_CI_AS null,
    type varchar(10) null
);

IF OBJECT_ID('dbo.mw_services', 'U') IS NOT NULL DROP TABLE dbo.mw_services;
create table mw_services (
    id integer identity(1, 1) primary key not null,
    service varchar(250) not null,
    active integer not null,
    sequence integer not null,
    url varchar(250) null,
    config_url varchar(250) null,
    parent_id integer null,
    allowed integer not null,
    rates varchar(max) null
);

IF OBJECT_ID('dbo.mw_service_translations', 'U') IS NOT NULL DROP TABLE dbo.mw_service_translations;
create table mw_service_translations (
    id integer identity(1, 1) primary key not null,
    name nvarchar(250) collate Latin1_General_CI_AS not null,
    service_id integer not null,
    locale varchar(20) not null
);

IF OBJECT_ID('dbo.mw_viptype_services', 'U') IS NOT NULL DROP TABLE dbo.mw_viptype_services;
create table mw_viptype_services (
    id integer identity(1, 1) primary key not null,
    viptype varchar(2) not null,
    service_id integer not null
);

IF OBJECT_ID('dbo.mw_users', 'U') IS NOT NULL DROP TABLE dbo.mw_users;
create table mw_users (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) collate Latin1_General_CI_AS not null,
    email varchar(200) null,
    username varchar(40) not null,
    password varchar(60) not null,
    super_user integer default 0 not null,
    secret_2fa varchar(200) null,
    group_id integer not null
);

IF OBJECT_ID('dbo.mw_user_groups', 'U') IS NOT NULL DROP TABLE dbo.mw_user_groups;
create table mw_user_groups (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) collate Latin1_General_CI_AS not null,
    access varchar(max) null
);

IF OBJECT_ID('dbo.mw_records', 'U') IS NOT NULL DROP TABLE dbo.mw_records;
create table mw_records (
    id integer identity(1, 1) primary key not null,
    type varchar(100) not null,
    record integer not null default 0,
    record_date datetime default getdate() not null,
);

IF OBJECT_ID('dbo.mw_jobs', 'U') IS NOT NULL DROP TABLE dbo.mw_jobs;
create table mw_jobs (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) collate Latin1_General_CI_AS not null,
    minutes varchar(50) not null default '*',
    hours varchar(50) not null default '*',
    days varchar(50) not null default '*',
    weeks varchar(50) not null default '*',
    months varchar(50) not null default '*',
    last_execution datetime null,
    script_file varchar(200) null,
    script varchar(max) null,
    result varchar(max) null,
    active integer not null default 0
);


IF OBJECT_ID('dbo.mw_posts', 'U') IS NOT NULL DROP TABLE dbo.mw_posts;
create table mw_posts (
    id integer identity(1, 1) primary key not null,
    title nvarchar(400) collate Latin1_General_CI_AS not null,
    slug varchar(400) not null,
    body nvarchar(MAX) collate Latin1_General_CI_AS not null,
    link varchar(400) collate Latin1_General_CI_AS null,
    create_date datetime default getdate() not null,
    type varchar(100) not null,
    views integer default 0 not null,
    user_id integer null,
    image_cover varchar(250) null,
    locale varchar(20) null,
    allow_comments integer default 0 not null,
    description nvarchar(MAX) collate Latin1_General_CI_AS null
);

IF OBJECT_ID('dbo.mw_posts_comments', 'U') IS NOT NULL DROP TABLE dbo.mw_posts_comments;
create table mw_posts_comments (
    id integer identity(1, 1) primary key not null,
    comment nvarchar(max) not null,
    author varchar(100) not null,
    admin integer default 0 not null,
    ip varchar(40) not null,
    create_date datetime default getdate() not null,
    post_id integer not null
);

IF OBJECT_ID('dbo.mw_helpdesk_tickets', 'U') IS NOT NULL DROP TABLE dbo.mw_helpdesk_tickets;
create table mw_helpdesk_tickets (
    id integer identity(1, 1) primary key not null,
    department nvarchar(200) collate Latin1_General_CI_AS not null,
    subject nvarchar(300) collate Latin1_General_CI_AS not null,
    message nvarchar(MAX) collate Latin1_General_CI_AS not null,
    create_date datetime default getdate() not null,
    update_date datetime null,
    responsible varchar(100) null,
    status integer default 1 not null,
    account varchar(10) not null,
    images varchar(700) null
);

IF OBJECT_ID('dbo.mw_helpdesk_ticket_messages', 'U') IS NOT NULL DROP TABLE dbo.mw_helpdesk_ticket_messages;
create table mw_helpdesk_ticket_messages (
    id integer identity(1, 1) primary key not null,
    message nvarchar(MAX) collate Latin1_General_CI_AS not null,
    admin integer default 0 not null,
    account varchar(100) not null,
    create_date datetime default getdate() not null,
    ticket_id integer not null,
    images varchar(700) null
);

IF OBJECT_ID('dbo.mw_package_categories', 'U') IS NOT NULL DROP TABLE dbo.mw_package_categories;
create table mw_package_categories (
    id integer identity(1, 1) primary key not null,
    name nvarchar(200) collate Latin1_General_CI_AS not null,
    slug varchar(400) not null,
    sequence integer not null,
    active integer not null
);

IF OBJECT_ID('dbo.mw_packages', 'U') IS NOT NULL DROP TABLE dbo.mw_packages;
create table mw_packages (
    id integer identity(1, 1) primary key not null,
    package nvarchar(200) collate Latin1_General_CI_AS not null,
    slug nvarchar(200) not null,
    description nvarchar(MAX) null,
    price numeric(10,2) not null,
    wallet_type_id integer not null,
    viptype integer null,
    vipdays integer null,
    coins varchar(max) null,
    active integer not null,
    sequence integer not null,
    image varchar(200) null,
    hidden integer not null default 0,
    max_sold integer null,
    category_id integer null,
    kit_id integer null
);

IF OBJECT_ID('dbo.mw_logs', 'U') IS NOT NULL DROP TABLE dbo.mw_logs;
create table mw_logs (
    id integer identity(1, 1) primary key not null,
    create_date datetime default getdate() not null,
    log varchar(max) not null,
    account varchar(10) not null,
    type varchar(50) null,
    table_name varchar(100) null,
    primary_key varchar(20) null,
    metadata varchar(max) null,
    user_id integer null
);

IF OBJECT_ID('dbo.mw_shops', 'U') IS NOT NULL DROP TABLE dbo.mw_shops;
create table mw_shops (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) collate Latin1_General_CI_AS not null,
    slug varchar(400) not null,
    description nvarchar(max) collate Latin1_General_CI_AS not null,
    coin varchar(20) not null,
    sequence integer not null,
    active integer not null,
    max_level integer not null default 13,
    max_option integer not null default 16,
    unique_sockets integer default 0,
    default_price_level integer null,
    default_price_option integer null,
    default_price_skill integer null,
    default_price_luck integer null,
    default_price_ancient integer null,
    default_price_harmony integer null,
    default_price_refine integer null,
    default_price_socket integer null,
    default_price_excellent integer null,
    default_price_element integer not null default 0,
    default_price_pentagram integer not null default 0,
    default_price_errtel integer not null default 0,
    default_max_excellent integer null,
    default_max_sockets integer null,
    default_max_pentagram integer not null default 0,
    default_max_errtel integer not null default 0,
    image varchar(100) null,
    allow_sockets integer null
);

IF OBJECT_ID('dbo.mw_shop_categories', 'U') IS NOT NULL DROP TABLE dbo.mw_shop_categories;
create table mw_shop_categories (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) collate Latin1_General_CI_AS not null,
    type varchar(100) null,
    slug varchar(400) not null,
    sequence integer not null,
    item_category integer null,
    icon varchar(200) null,
    active integer not null,
    parent_id integer null,
    shop_id integer not null
);

IF OBJECT_ID('dbo.mw_shop_items', 'U') IS NOT NULL DROP TABLE dbo.mw_shop_items;
create table mw_shop_items (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) collate Latin1_General_CI_AS not null,
    section integer not null,
    [index] integer not null,
    durability integer not null default 255,
    x_size integer not null default 1,
    y_size integer not null default 1,
    ancient varchar(30) null,
    skill integer not null default 0,
    refine integer not null default 0,
    sockets integer not null default 0,
    harmony integer not null default 0,
    slug varchar(400) not null,
    active integer not null,
    price integer not null default 0,
    price_level integer not null default 0,
    price_option integer not null default 0,
    price_skill integer not null default 0,
    price_luck integer not null default 0,
    price_ancient integer not null default 0,
    price_harmony integer not null default 0,
    price_refine integer not null default 0,
    price_socket integer not null default 0,
    price_excellent integer not null default 0,
    price_element integer not null default 0,
    price_pentagram integer not null default 0,
    price_errtel integer not null default 0,
    max_excellent integer not null default 6,
    max_sockets integer not null default 5,
    max_pentagram integer not null default 5,
    max_errtel integer not null default 5,
    quantity varchar(10) null,
    image varchar(100) null,
    sold integer not null default 0,
    offer integer not null default 0,
    fix_level integer not null default -1,
    fix_option integer not null default -1,
    fix_durability integer not null default -1,
    luck integer not null default 1,
    stock integer null,
    category_id integer null,
    item_id integer null,
    shop_item_id integer null,
    is_kit integer not null default 0,
    item_hex varchar(64) null,
    product_type varchar(40) not null default 'common'
);

IF OBJECT_ID('dbo.mw_shop_coupons', 'U') IS NOT NULL DROP TABLE dbo.mw_shop_coupons;
create table mw_shop_coupons (
    id integer identity(1, 1) primary key not null,
    coupon varchar(100) not null,
    start_date date null,
    expire_date date null,
    shop_id integer null,
    active integer not null,
    discount numeric(10,2) not null,
    create_date datetime default getdate() not null
);

IF OBJECT_ID('dbo.mw_orders', 'U') IS NOT NULL DROP TABLE dbo.mw_orders;
create table mw_orders (
    id integer identity(1, 1) primary key not null,
    username varchar(10) not null,
    gateway varchar(100) not null,
    code varchar(400) null,
    value numeric(10,2) not null,
    total numeric(10,2) null,
    delivery numeric(10,2) null,
    status integer not null,
    currency varchar(10) null,
    create_date datetime default getdate() not null,
    transaction_id varchar(100) null,
    data varchar(max) null,
    tbl varchar(100) null,
    tbl_id integer null,
    email varchar(255) null,
    use_email int not null default 0,
    coupon_id integer null,
    locked integer not null default 0
);

IF OBJECT_ID('dbo.mw_bank_accounts', 'U') IS NOT NULL DROP TABLE dbo.mw_bank_accounts;
create table mw_bank_accounts (
    id integer identity(1, 1) primary key not null,
    name varchar(100) not null,
    account varchar(40) not null,
    agency varchar(10) not null,
    operation varchar(10) null,
    favored varchar(200) not null,
    document varchar(30) not null,
    logo varchar(150) null,
    notes nvarchar(MAX) collate Latin1_General_CI_AS not null,
    sequence integer not null default 1
);

IF OBJECT_ID('dbo.mw_payment_confirmations', 'U') IS NOT NULL DROP TABLE dbo.mw_payment_confirmations;
create table mw_payment_confirmations (
    id integer identity(1, 1) primary key not null,
    value numeric(10, 2) not null,
    message nvarchar(MAX) collate Latin1_General_CI_AS not null,
    create_date datetime default getdate() not null,
    update_date datetime null,
    bank_account_id integer null,
    status integer default 1 not null,
    account varchar(10) not null,
    images varchar(700) null
);

IF OBJECT_ID('dbo.mw_payment_confirmation_messages', 'U') IS NOT NULL DROP TABLE dbo.mw_payment_confirmation_messages;
create table mw_payment_confirmation_messages (
    id integer identity(1, 1) primary key not null,
    message nvarchar(MAX) collate Latin1_General_CI_AS not null,
    admin integer default 0 not null,
    account varchar(100) not null,
    create_date datetime default getdate() not null,
    confirmation_id integer not null,
    images varchar(700) null
);

IF OBJECT_ID('dbo.mw_polls', 'U') IS NOT NULL DROP TABLE dbo.mw_polls;
create table mw_polls (
    id integer identity(1, 1) primary key not null,
    title varchar(200) not null,
    start_date date default getdate() not null,
    end_date date null,
    active integer default 0 not null,
    allow_multiple integer default 0 not null,
    only_logged_in integer default 0 not null,
    allow_ips integer default 0 not null
);

IF OBJECT_ID('dbo.mw_polls_answers', 'U') IS NOT NULL DROP TABLE dbo.mw_polls_answers;
create table mw_polls_answers (
    id integer identity(1, 1) primary key not null,
    answer varchar(200) not null,
    poll_id integer not null,
    sequence integer null,
    total integer default 0 not null
);

IF OBJECT_ID('dbo.mw_polls_answers_persons', 'U') IS NOT NULL DROP TABLE dbo.mw_polls_answers_persons;
create table mw_polls_answers_persons (
    id integer identity(1, 1) primary key not null,
    answer_id integer not null,
    ip varchar(40) not null,
    account varchar(10) null
);

IF OBJECT_ID('dbo.mw_market_items', 'U') IS NOT NULL DROP TABLE dbo.mw_market_items;
create table mw_market_items (
    id integer identity(1, 1) primary key not null,
    hex varchar(64) not null,
    payment_type varchar(10) not null,
    coin varchar(100) null,
    price varchar(10) not null,
    wallet_type_id integer null,
    account varchar(10) not null,
    selling_start_date datetime not null,
    bought_by varchar(10) null,
    bought_date date null,
    item_name varchar(100) not null,
    item_section integer not null,
    item_level integer not null,
    item_option integer not null
);

IF OBJECT_ID('dbo.mw_auth_tokens', 'U') IS NOT NULL DROP TABLE dbo.mw_auth_tokens;
create table mw_auth_tokens (
    id integer identity(1, 1) primary key not null,
    token varchar(40) not null,
    account varchar(10) not null,
    expires bigint not null
);

IF OBJECT_ID('dbo.mw_indication_goals', 'U') IS NOT NULL DROP TABLE dbo.mw_indication_goals;
create table mw_indication_goals (
    id integer identity(1, 1) primary key not null,
    goal varchar(200) not null,
    coin varchar(20) not null,
    amount varchar(max) not null
);

IF OBJECT_ID('dbo.mw_indication_rewards', 'U') IS NOT NULL DROP TABLE dbo.mw_indication_rewards;
create table mw_indication_rewards (
    id integer identity(1, 1) primary key not null,
    account varchar(10) not null,
    indication varchar(10) not null,
    indication_goal_id integer not null,
    rewarded integer not null default 0,
    amount integer not null default 0
);

IF OBJECT_ID('dbo.mw_slides', 'U') IS NOT NULL DROP TABLE dbo.mw_slides;
create table mw_slides (
    id integer identity(1, 1) primary key not null,
    image varchar(200) not null,
    title varchar(300) null,
    url varchar(300) null,
    active integer not null default 0,
    sequence integer null,
    type varchar(20) not null default 'slide',
    links varchar(max) null
);

IF OBJECT_ID('dbo.mw_messages', 'U') IS NOT NULL DROP TABLE dbo.mw_messages;
create table mw_messages (
    id integer identity(1, 1) primary key not null,
    title varchar(200) not null,
    message varchar(max) not null,
    account varchar(10) null,
    create_date datetime default getdate() not null
);

IF OBJECT_ID('dbo.mw_messages_read', 'U') IS NOT NULL DROP TABLE dbo.mw_messages_read;
create table mw_messages_read (
    id integer identity(1, 1) primary key not null,
    account varchar(10) not null,
    message_id integer not null
);

IF OBJECT_ID('dbo.mw_items', 'U') IS NOT NULL DROP TABLE dbo.mw_items;
create table mw_items (
    id integer identity(1, 1) primary key not null,
    section integer not null,
    [index] integer not null,
    name varchar(100) not null,
    width integer not null,
    height integer not null,
    slot varchar(5) null,
    has_skill integer not null default 0,
    durability integer not null default 0,
    dw integer null,
    dk integer null,
    fe integer null,
    mg integer null,
    dl integer null,
    su integer null,
    rf integer null,
    gl integer null,
    rw integer null,
    sy integer null,
    gc integer null,
    lw integer null,
    lem integer null,
    ik integer null,
    req_level integer null,
    req_strength integer null,
    req_agility integer null,
    req_vitality integer null,
    req_energy integer null,
    req_command integer null,
    min_damage integer null,
    max_damage integer null,
    attack_speed integer null,
    magic_durability integer null,
    magic_damage integer null,
    defense integer null,
    defense_success integer null,
    walk_speed integer null,
    res_ice integer null,
    res_poison integer null,
    res_light integer null,
    res_fire integer null,
    res_earth integer null,
    res_wind integer null,
    res_water integer null
);

IF OBJECT_ID('dbo.mw_achievements', 'U') IS NOT NULL DROP TABLE dbo.mw_achievements;
create table mw_achievements (
    id integer identity(1, 1) primary key not null,
    name varchar(200) not null,
    description varchar(max),
    require_id integer,
    sequence integer null,
    active int default 0 not null
);

IF OBJECT_ID('dbo.mw_achievements_account', 'U') IS NOT NULL DROP TABLE dbo.mw_achievements_account;
create table mw_achievements_account(
    id integer identity(1, 1) primary key not null,
    achievement_id integer not null,
    account varchar(10) not null
);

IF OBJECT_ID('dbo.mw_achievements_requirements', 'U') IS NOT NULL DROP TABLE dbo.mw_achievements_requirements;
create table mw_achievements_requirements(
    id integer identity(1, 1) primary key not null,
    title varchar(200) not null,
    type varchar(2) null,
    sql varchar(max),
    achievement_id integer
);

IF OBJECT_ID('dbo.mw_achievements_rewards', 'U') IS NOT NULL DROP TABLE dbo.mw_achievements_rewards;
create table mw_achievements_rewards(
    id integer identity(1, 1) primary key not null,
    title varchar(200) not null,
    sql varchar(max),
    achievement_id integer
);

IF OBJECT_ID('dbo.mw_auctions', 'U') IS NOT NULL DROP TABLE dbo.mw_auctions;
create table mw_auctions (
    id integer identity(1, 1) primary key not null,
    name varchar(100) not null,
    slug varchar(100) not null,
    description varchar(max) null,
    image varchar(200) null,
    start_date date null,
    end_date date null,
    active integer not null default 0
);

IF OBJECT_ID('dbo.mw_auction_items', 'U') IS NOT NULL DROP TABLE dbo.mw_auction_items;
create table mw_auction_items (
    id integer identity(1, 1) primary key not null,
    item_id integer not null,
    hex varchar(64) not null,
    active integer not null default 0,
    winner varchar(10) null,
    winner_date datetime null,
    delivery integer not null default 0,
    coin varchar(20) not null,
    initial_bid integer not null default 0,
    best_bid integer not null default 0,
    best_bid_date datetime null,
    best_bid_account varchar(10) null,
    parent_id integer null,
    auction_id integer not null
);

IF OBJECT_ID('dbo.mw_events', 'U') IS NOT NULL DROP TABLE dbo.mw_events;
create table mw_events (
    id integer identity(1, 1) primary key not null,
    name varchar(100) not null,
    notifiable integer not null default 1,
    featured integer not null default 1,
    times varchar(max) null,
    sequence integer null,
    category_id integer null
);

IF OBJECT_ID('dbo.mw_event_categories', 'U') IS NOT NULL DROP TABLE dbo.mw_event_categories;
create table mw_event_categories (
    id integer identity(1, 1) primary key not null,
    name varchar(100) not null,
    sequence integer null
);

IF OBJECT_ID('dbo.mw_lootboxes', 'U') IS NOT NULL DROP TABLE dbo.mw_lootboxes;
create table mw_lootboxes (
    id integer identity(1, 1) primary key not null,
    name varchar(200) not null,
    slug varchar(200) not null,
    description varchar(max) null,
    image varchar(150) null,
    expire_date date null,
    coin varchar(20) not null,
    amount integer not null,
    active integer not null default 0,
    sequence integer null,
    open_type varchar(20) not null default 'wheel',
    gift_register integer null
);

IF OBJECT_ID('dbo.mw_lootboxes_items', 'U') IS NOT NULL DROP TABLE dbo.mw_lootboxes_items;
create table mw_lootboxes_items (
    id integer identity(1, 1) primary key not null,
    section integer not null,
    [index] integer not null,
    name varchar(200) not null,
    durability integer null,
    item_percent float not null,
    percent_levels varchar(max) not null,
    percent_options varchar(max) not null,
    percent_luck float not null default 0,
    percent_skill float not null default 0,
    percent_ancient float not null default 0,
    percent_exc varchar(max) not null,
    percent_refine float not null default 0,
    percent_harmony float not null default 0,
    percent_sockets varchar(max) null,
    lootbox_id integer not null,
    rarity_id integer null
);

IF OBJECT_ID('dbo.mw_lootboxes_rarities', 'U') IS NOT NULL DROP TABLE dbo.mw_lootboxes_rarities;
create table mw_lootboxes_rarities (
      id integer identity(1, 1) primary key not null,
      name varchar(200) not null,
      color varchar(10) not null
);

IF OBJECT_ID('dbo.mw_lootboxes_account', 'U') IS NOT NULL DROP TABLE dbo.mw_lootboxes_account;
create table mw_lootboxes_account (
    id integer identity(1, 1) primary key not null,
    lootbox_id integer not null,
    lootbox_item_id integer null,
    account varchar(10) not null,
    gift_from varchar(10) null,
    open_date date null,
    item varchar(64) null,
    create_date date not null default getdate()
);

IF OBJECT_ID('dbo.mw_patents', 'U') IS NOT NULL DROP TABLE dbo.mw_patents;
create table mw_patents (
    id integer identity(1, 1) primary key not null,
    code integer null,
    image varchar(200) null,
    title varchar(300) null,
    command varchar(max) null,
    resets integer null,
    levels integer null,
    master_levels integer null,
    master_resets integer null,
    sequence integer null,
    active integer not null default 0
);

if not exists (
select *
from sys.columns
where object_id = OBJECT_ID(N'[dbo].[Character]')
and name = 'PatentId'
)
begin alter table Character add PatentId integer null end;

IF OBJECT_ID('dbo.mw_vote_reward_providers', 'U') IS NOT NULL DROP TABLE dbo.mw_vote_reward_providers;
create table mw_vote_reward_providers (
    id integer identity(1, 1) primary key not null,
    name varchar(100) not null,
    api varchar(100) null,
    coin varchar(50) not null,
    amount integer not null,
    url varchar(200) not null,
    image varchar(150) null,
    allow integer null,
    delay integer not null default 0,
    active integer not null default 0,
);

IF OBJECT_ID('dbo.mw_vote_reward_votes', 'U') IS NOT NULL DROP TABLE dbo.mw_vote_reward_votes;
create table mw_vote_reward_votes (
    id integer identity(1, 1) primary key not null,
    provider integer not null,
    account varchar(10) not null,
    ip varchar(60) not null,
    create_date datetime default getdate() not null,
    status integer not null default 1
);

IF OBJECT_ID('dbo.mw_videos', 'U') IS NOT NULL DROP TABLE dbo.mw_videos;
create table mw_videos (
    id integer identity(1, 1) primary key not null,
    title varchar(300) null,
    description varchar(max) null,
    url varchar(300) not null,
    active integer not null default 0,
    sequence integer null
);

IF OBJECT_ID('dbo.mw_tracker_categories', 'U') IS NOT NULL DROP TABLE dbo.mw_tracker_categories;
create table mw_tracker_categories (
    id integer identity(1, 1) primary key not null,
    name varchar(300) null,
    slug varchar(300) null,
    status varchar(max) null,
    is_public integer not null default 1,
    active integer not null default 0
);

IF OBJECT_ID('dbo.mw_tracker_versions', 'U') IS NOT NULL DROP TABLE dbo.mw_tracker_versions;
create table mw_tracker_versions (
    id integer identity(1, 1) primary key not null,
    version varchar(300) null,
    status varchar(2) null,
    changelog nvarchar(MAX) collate Latin1_General_CI_AS null,
    available integer not null default 1
);

IF OBJECT_ID('dbo.mw_trackers', 'U') IS NOT NULL DROP TABLE dbo.mw_trackers;
create table mw_trackers (
    id integer identity(1, 1) primary key not null,
    title varchar(200) not null,
    description varchar(max) not null,
    reproduce varchar(max) not null,
    is_public integer not null default 1,
    version_id integer,
    fixed_version_id integer null,
    category_id integer,
    status integer null,
    system varchar(50) null,
    create_date datetime not null default getdate(),
    images varchar(max) null,
    frequency integer not null default 1,
    account varchar(10) null,
    up integer not null default 0,
    down integer not null default 0,
    closed integer not null default 0
);

IF OBJECT_ID('dbo.mw_trackers_comments', 'U') IS NOT NULL DROP TABLE dbo.mw_trackers_comments;
create table mw_trackers_comments (
    id integer identity(1, 1) primary key not null,
    comment nvarchar(max) not null,
    author varchar(100) not null,
    account varchar(10) not null,
    ip varchar(40) not null,
    create_date datetime default getdate() not null,
    tracker_id integer not null,
    admin integer not null default 0
);

IF OBJECT_ID('dbo.mw_trackers_votes', 'U') IS NOT NULL DROP TABLE dbo.mw_trackers_votes;
create table mw_trackers_votes (
    id integer identity(1, 1) primary key not null,
    tracker_id integer not null,
    ip varchar(40) not null,
    account varchar(10) null
);

IF OBJECT_ID('dbo.mw_exchange_hour_packages', 'U') IS NOT NULL DROP TABLE dbo.mw_exchange_hour_packages;
create table mw_exchange_hour_packages (
    id integer identity(1, 1) primary key not null,
    package nvarchar(200) collate Latin1_General_CI_AS not null,
    description nvarchar(MAX) null,
    hours float not null,
    viptype integer null,
    vipdays integer null,
    coins varchar(max) null,
    sql varchar(max) null,
    active integer not null,
    sequence integer not null,
    image varchar(200) null
);

IF OBJECT_ID('dbo.mw_guide_categories', 'U') IS NOT NULL DROP TABLE dbo.mw_guide_categories;
create table mw_guide_categories (
    id integer identity(1, 1) primary key not null,
    name nvarchar(200) collate Latin1_General_CI_AS not null,
    sequence integer not null,
    active integer not null,
    slug varchar(200) not null
);

IF OBJECT_ID('dbo.mw_guides', 'U') IS NOT NULL DROP TABLE dbo.mw_guides;
create table mw_guides (
    id integer identity(1, 1) primary key not null,
    title nvarchar(300) collate Latin1_General_CI_AS not null,
    description nvarchar(MAX) collate Latin1_General_CI_AS not null,
    category_id integer not null,
    sequence integer not null,
    active integer not null,
    up integer not null default 0,
    down integer not null default 0,
    slug varchar(200) not null
);

IF OBJECT_ID('dbo.mw_guide_votes', 'U') IS NOT NULL DROP TABLE dbo.mw_guide_votes;
create table mw_guide_votes (
    id integer identity(1, 1) primary key not null,
    guide_id integer not null,
    ip varchar(40) not null,
    account varchar(10) null
);

IF OBJECT_ID('dbo.mw_raffles', 'U') IS NOT NULL DROP TABLE dbo.mw_raffles;
create table mw_raffles (
    id integer identity(1, 1) primary key not null,
    name varchar(300) collate Latin1_General_CI_AS not null,
    slug nvarchar(300) not null,
    active integer not null,
    description nvarchar(MAX) null,
    winner varchar(10) null,
    winner_date datetime null,
    number integer null,
    total_numbers integer not null,
    create_date datetime default getdate() not null,
    price numeric(10,2) not null,
    type integer not null default 1,
    vip_type integer null,
    vip_days integer null,
    coins varchar(max) null,
    wallets varchar(max) null,
    wallet_type_id integer not null,
    custom varchar(max) null
);

IF OBJECT_ID('dbo.mw_raffle_numbers', 'U') IS NOT NULL DROP TABLE dbo.mw_raffle_numbers;
create table mw_raffle_numbers (
    id integer identity(1, 1) primary key not null,
    number integer not null,
    raffle_id integer not null,
    account varchar(10) not null
);

IF OBJECT_ID('dbo.mw_countdowns', 'U') IS NOT NULL DROP TABLE dbo.mw_countdowns;
create table mw_countdowns (
    id integer identity(1, 1) primary key not null,
    title nvarchar(300) collate Latin1_General_CI_AS not null,
    count_date datetime not null,
    active integer not null,
    message nvarchar(MAX) null
);

IF OBJECT_ID('dbo.mw_direct_market_items', 'U') IS NOT NULL DROP TABLE dbo.mw_direct_market_items;
create table mw_direct_market_items (
    id integer identity(1, 1) primary key not null,
    hex varchar(64) not null,
    price decimal(10, 2) not null,
    account varchar(10) not null,
    target varchar(10) not null,
    create_date datetime default getdate() not null,
    status varchar(20) not null default 'pending',
    order_id integer null
);

if not exists (
select *
from sys.columns
where object_id = OBJECT_ID(N'[dbo].[MEMB_INFO]')
and name = 'country'
)
begin alter table MEMB_INFO add country varchar(2) null end;

if not exists (
    select *
    from sys.columns
    where object_id = OBJECT_ID(N'[dbo].[MEMB_INFO]') and name = 'tfa_secret'
)
begin alter table MEMB_INFO add tfa_secret varchar(200) null end;

if not exists (
    select *
    from sys.columns
    where object_id = OBJECT_ID(N'[dbo].[MEMB_INFO]') and name = 'tfa_enabled'
)
begin alter table MEMB_INFO add tfa_enabled integer not null default 0 end;

IF OBJECT_ID('dbo.mw_account_market_accounts', 'U') IS NOT NULL DROP TABLE dbo.mw_account_market_accounts;
create table mw_account_market_accounts (
    id integer identity(1, 1) primary key not null,
    price decimal(10, 2) not null,
    account varchar(10) not null,
    create_date datetime default getdate() not null,
    status varchar(20) not null default 'pending',
    pix varchar(100) not null,
    contact varchar(200) not null,
    order_id integer null,
    paid integer not null default 0
);


IF OBJECT_ID('dbo.mw_coupons', 'U') IS NOT NULL DROP TABLE dbo.mw_coupons;
create table mw_coupons (
    id integer identity(1, 1) primary key not null,
    coupon varchar(100) not null,
    scope varchar(100) null,
    start_date date null,
    expire_date date null,
    active integer not null,
    discount numeric(10,2) not null,
    cashback numeric(10,2) null,
    cashback_wallet_type_id int null,
    owner varchar(10) null,
    quantity integer null,
    used integer not null default 0,
    create_date datetime default getdate() not null
);

IF OBJECT_ID('dbo.mw_rescues', 'U') IS NOT NULL DROP TABLE dbo.mw_rescues;
create table mw_rescues (
    id integer identity(1, 1) primary key not null,
    account varchar(10) not null,
    value decimal(10, 2) not null,
    tax float not null default 0,
    wallet_type_id int null,
    status varchar(20) not null default 'pending',
    pix varchar(100) not null,
    create_date datetime not null default getdate()
);

-- if not exists (
-- select *
-- from sys.columns
-- where object_id = OBJECT_ID(N'[dbo].[MEMB_INFO]')
-- and name = 'cashback_credits'
-- )
-- begin alter table MEMB_INFO add cashback_credits numeric(10, 2) not null default 0 end;

if not exists (
    select *
    from sys.columns
    where object_id = OBJECT_ID(N'[dbo].[MEMB_INFO]')
      and name = 'indication_streamer_by'
)
begin alter table MEMB_INFO add indication_streamer_by varchar(10) null end;


IF OBJECT_ID('dbo.mw_streamers', 'U') IS NOT NULL DROP TABLE dbo.mw_streamers;
create table mw_streamers (
    id integer identity(1, 1) primary key not null,
    account varchar(10) not null,
    twitch varchar(100) not null,
    status varchar(10) not null default 'pending',
    cashback numeric(10,2) null,
    link varchar(100) null,
    create_date datetime not null default getdate()
);

IF OBJECT_ID('dbo.mw_profile_block_packages', 'U') IS NOT NULL DROP TABLE dbo.mw_profile_block_packages;
create table mw_profile_block_packages (
   id integer identity(1, 1) primary key not null,
   package nvarchar(200) collate Latin1_General_CI_AS not null,
   description nvarchar(MAX) null,
   hours varchar(10) not null,
   active integer not null,
   sequence integer not null,
   image varchar(200) null,
   amount_hours varchar(10) null,
   amount_wallet_value float null,
    amount_wallet_type_id integer null
);

if not exists (
select *
from sys.columns
where object_id = OBJECT_ID(N'[dbo].[Character]')
and name = 'profile_blocked_until'
)
begin alter table Character add profile_blocked_until datetime null end;

IF OBJECT_ID('dbo.mw_workshop_rules', 'U') IS NOT NULL DROP TABLE dbo.mw_workshop_rules;
create table mw_workshop_rules (
    id integer identity(1, 1) primary key not null,
    name nvarchar(100) not null,
    section integer null,
    [index] integer null,
    active integer not null,
    max_level integer not null default 0,
    max_option integer not null default 0,
    max_excellent integer not null default 0,
    max_socket integer not null default 0,
    max_pentagram integer not null default 0,
    max_errtel integer not null default 0,
    allow_ancient integer not null default 0,
    allow_refine integer not null default 0,
    allow_harmony integer not null default 0,
    allow_socket integer not null default 0,
    allow_socket_type integer not null default 0,
    allow_mastery integer not null default 0,
    allow_mastery_bonus integer not null default 0,
    allow_ancient_with_excellent integer not null default 0,
    allow_ancient_with_socket integer not null default 0,
);

IF OBJECT_ID('dbo.mw_workshop_rule_prices', 'U') IS NOT NULL DROP TABLE dbo.mw_workshop_rule_prices;
create table mw_workshop_rule_prices (
    id integer identity(1, 1) primary key not null,
    rule_id integer not null,
    coin varchar(100) not null,
    prices nvarchar(max) not null
);


IF OBJECT_ID('dbo.mw_wallet_types', 'U') IS NOT NULL DROP TABLE dbo.mw_wallet_types;
create table mw_wallet_types (
    id integer identity(1, 1) primary key not null,
    name varchar(100) not null,
    create_date datetime not null default getdate()
);

IF OBJECT_ID('dbo.mw_wallets', 'U') IS NOT NULL DROP TABLE dbo.mw_wallets;
create table mw_wallets (
    id integer identity(1, 1) primary key not null,
    account varchar(10) not null,
    wallet_type_id integer not null,
    balance float not null default 0
);

IF OBJECT_ID('dbo.mw_wallet_transactions', 'U') IS NOT NULL DROP TABLE dbo.mw_wallet_transactions;
create table mw_wallet_transactions (
    id integer identity(1, 1) primary key not null,
    wallet_id integer not null,
    description nvarchar(300) null,
    value float not null default 0,
    create_date datetime not null default getdate()
);

IF OBJECT_ID('dbo.mw_sql_logs', 'U') IS NOT NULL DROP TABLE dbo.mw_sql_logs;
create table mw_sql_logs (
    id integer identity(1, 1) primary key not null,
    executed_at smalldatetime not null,
    duration float not null,
    sql_query text not null,
    uri text null,
    params text null,
    ip varchar(250) null,
    username varchar(10) null
);

IF OBJECT_ID('dbo.mw_http_logs', 'U') IS NOT NULL DROP TABLE dbo.mw_http_logs;
CREATE TABLE mw_http_logs (
    id integer identity(1, 1) primary key not null,
    executed_at smalldatetime not null,
    ip varchar(250) null,
    method varchar(10) null,
    uri text null,
    params text null,
    duration float null,
    username varchar(10) null
);