DOMLoaded(() => {
    const countdowns = document.querySelectorAll('.countdowns .countdown');

    function formatTime(time) {
        return time < 10 ? `0${time}` : time;
    }

    countdowns.forEach(el => {
        const daysElement = el.querySelector('.days');
        const hoursElement = el.querySelector('.hours');
        const minutesElement = el.querySelector('.minutes');
        const secondsElement = el.querySelector('.seconds');

        function render() {
            const currentDate = new Date();
            const countdownDate = new Date(el.dataset.countdown);
            const totalSeconds = (countdownDate - currentDate) / 1000;

            const days = Math.floor(totalSeconds / 3600 / 24);
            const hours = Math.floor(totalSeconds / 3600) % 24;
            const minutes = Math.floor(totalSeconds / 60) % 60;
            const seconds = Math.floor(totalSeconds) % 60;

            daysElement.querySelector('span').innerHTML = formatTime(days);
            hoursElement.querySelector('span').innerHTML = formatTime(hours);
            minutesElement.querySelector('span').innerHTML = formatTime(minutes);
            secondsElement.querySelector('span').innerHTML = formatTime(seconds);

            const timer = el.querySelector('.countdown-timer');
            timer.style.opacity = 100;
            if (days <= 0 && hours <= 0 && minutes <= 0 && seconds <= 0) {
                timer.classList.remove('countdown-timer');
                timer.classList.add('countdown-message');
                timer.innerHTML = el.dataset.message;
            } else {
                setTimeout(render, 1000);
            }
        }

        render();
    });
});