DOMLoaded(() => {
    const numberButtons = document.querySelectorAll('[data-raffle-number]');
    const rafflePurchasePrice = document.querySelector('[data-raffle-purchase-price]');
    const raffleNumbers = document.querySelector('[data-raffle-selected-numbers]');
    numberButtons.forEach(el => {
        el.addEventListener('click', e => {
            el.classList.toggle('active');

            const selected = document.querySelectorAll('[data-raffle-number].active');
            const numbers = [];
            selected.forEach(el2 => {
                numbers.push(el2.dataset.raffleNumber);
            });

            raffleNumbers.value = numbers.join(',');

            rafflePurchasePrice.innerHTML = new Intl.NumberFormat(window.Morpheus.locale.replace('_', '-'), { style: 'currency', currency: window.Morpheus.currency }).format(
                numbers.length * Number(el.dataset.rafflePrice),
            )
        });
    });
});