document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById('slides-modal');
    if (modal) {
        const lastModalOpen = localStorage.getItem('last_modal_at');
        const now = new Date().getTime();
        const interval = parseInt(modal.dataset.showInterval || 0, 10) * 1000;

        if (!lastModalOpen || (parseInt(lastModalOpen, 10) + interval) <= now) {
            const modalInstance = new bootstrap.Modal(modal);
            const carousel = document.getElementById('slides-modal-carousel');

            modalInstance.show();

            carousel.addEventListener('slide.bs.carousel', function (event) {
                document.querySelectorAll('[data-modal-index]').forEach(element => element.style.display = 'none');
                document.querySelectorAll(`[data-modal-index='${event.to}']`).forEach(element => element.style.display = 'block');
            });

            localStorage.setItem('last_modal_at', now.toString());
        }
    }
});