document.addEventListener("DOMContentLoaded", function () {
  // ============ NAVBAR MOBILE ============
  const mobileToggle = document.getElementById("mobileToggle");
  const navMenu = document.getElementById("navMenu");

  if (mobileToggle && navMenu) {
    mobileToggle.addEventListener("click", function (e) {
      e.stopPropagation();
      navMenu.classList.toggle("active");
      mobileToggle.classList.toggle("active");
    });

    document.addEventListener("click", function (e) {
      const isClickInsideMenu =
        navMenu.contains(e.target) || mobileToggle.contains(e.target);

      if (!isClickInsideMenu) {
        navMenu.classList.remove("active");
        mobileToggle.classList.remove("active");
      }
    });

    const navLinks = document.querySelectorAll(
      ".nav-link:not(.dropdown .nav-link)"
    );
    navLinks.forEach((link) => {
      link.addEventListener("click", function () {
        if (window.innerWidth <= 768) {
          navMenu.classList.remove("active");
          mobileToggle.classList.remove("active");
        }
      });
    });
  }

  // ============ NAVBAR SCROLL EFFECT ============
  const navbar = document.querySelector(".navbar");
  if (navbar) {
    navbar.style.background = "rgba(20, 20, 20, 0.3)";
    navbar.style.transition =
      "background 0.5s ease-in-out, box-shadow 0.3s ease, backdrop-filter 0.5s ease";
    navbar.style.backdropFilter = "none";
    navbar.style.borderBottom = "none";

    window.addEventListener("scroll", function () {
      if (window.scrollY > 50) {
        navbar.style.background = "rgba(20, 20, 20, 0.9)";
        navbar.style.backdropFilter = "blur(5px)";
        navbar.style.boxShadow = "0 2px 10px rgba(0, 0, 0, 0.1)";
      } else {
        navbar.style.background = "rgba(20, 20, 20, 0.3)";
        navbar.style.backdropFilter = "none";
        navbar.style.boxShadow = "none";
      }
    });
  }

  // ============ DROPDOWNS ============
  const dropdowns = document.querySelectorAll(".dropdown");
  dropdowns.forEach((dropdown) => {
    const trigger = dropdown.querySelector(".nav-link, .language-current");
    if (trigger) {
      trigger.addEventListener("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        dropdowns.forEach((other) => {
          if (other !== dropdown) other.classList.remove("active");
        });
        dropdown.classList.toggle("active");
      });
    }
  });

  document.addEventListener("click", function (e) {
    if (!e.target.closest(".dropdown")) {
      dropdowns.forEach((dropdown) => {
        dropdown.classList.remove("active");
      });
    }
  });

  // ============ LANGUAGE SELECTOR ============
  const languageDropdown = document.getElementById("navbarLanguage");
  const languageToggle = document.getElementById("languageDropdownToggle");
  const languageMenu = document.getElementById("languageDropdownMenu");

  if (languageToggle && languageMenu) {
    languageToggle.addEventListener("click", function (e) {
      e.preventDefault();
      e.stopPropagation();
      languageMenu.classList.toggle("active");
    });

    document.addEventListener("click", function (e) {
      if (languageDropdown && !languageDropdown.contains(e.target)) {
        languageMenu.classList.remove("active");
      }
    });

    const languageOptions = document.querySelectorAll(".language-option");
    languageOptions.forEach((option) => {
      option.addEventListener("click", function (e) {
        e.preventDefault();
        const lang = this.getAttribute("data-lang");
        const flagSrc = this.querySelector("img").src;
        const langName = this.querySelector("span").textContent;

        document.getElementById("currentLanguageFlag").src = flagSrc;
        document.getElementById("currentLanguageName").textContent = langName;
        languageMenu.classList.remove("active");

        // Redireciona para mudar o idioma no backend
        window.location.href = this.getAttribute("href");
      });
    });
  }

  // ============ EVENTS CATEGORIES - VERSÃO OTIMIZADA ============
  function initEventsCategories() {
    const categoryLinks = document.querySelectorAll(".nav-link-event");
    const eventsPanes = document.querySelectorAll(".events-list");

    if (categoryLinks.length === 0 || eventsPanes.length === 0) return;

    categoryLinks.forEach((link) => {
      link.addEventListener("click", function (e) {
        e.preventDefault();

        const targetId = this.getAttribute("data-bs-target");
        const targetPane = document.querySelector(targetId);

        if (!targetPane) return;

        // Remove todas as classes ativas
        categoryLinks.forEach((l) => l.classList.remove("active"));
        eventsPanes.forEach((p) => {
          p.classList.remove("show", "active");
        });

        // Ativa o link clicado e o painel correspondente
        this.classList.add("active");
        targetPane.classList.add("show", "active");
      });
    });
  }
  // Controle das tabs
  document.querySelectorAll(".ranking-tab").forEach((tab) => {
    tab.addEventListener("click", function () {
      const index = this.getAttribute("data-ranking");

      // Remove classes ativas
      document
        .querySelectorAll(".ranking-tab, .ranking-table")
        .forEach((el) => el.classList.remove("active"));

      // Ativa tab e tabela correspondentes
      this.classList.add("active");
      document
        .querySelectorAll(".ranking-table")
        [index].classList.add("active");
    });
  });
});

function playVideo(element) {
  element.classList.add("playing");
  element.innerHTML =
    '<iframe src="https://www.youtube.com/embed/POzR63w0Po0?autoplay=1" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;"></iframe>';
}

document.addEventListener("DOMContentLoaded", function () {
  document
    .querySelectorAll("#accordionUser .accordion-button")
    .forEach(function (btn) {
      btn.addEventListener("click", function (e) {
        e.stopPropagation(); // impede o dropdown de fechar
      });
    });
});
