$cssPath = "e:\Projetos\Mutronic\2026\site_v1.1\site\templates\tronic\assets\css\app.css"
$content = Get-Content -Path $cssPath -Raw

# Helper to escape regex special chars in keys
function Escape-Regex($str) {
    return [Regex]::Escape($str)
}

# Define replacements (Order matters? Not really for these unique keys, but exact string matching is safer)
$replacements = @{
    "#b50000" = "#1A4B8C"; # Raffle Active Bg -> Dark Blue
    "#ff0000" = "#3794FF"; # Raffle Active Border -> Blue
    "#e62424" = "#3794FF"; # Raffle Allowed Border -> Blue
    "#a51717" = "#1A4B8C"; # Accordion Border -> Dark Blue
    "#6f0f0f" = "#3794FF"; # Streamer Hover -> Blue
    "#9e2222" = "#3794FF"; # Castle Date -> Blue
    "#c63c3c" = "#3794FF"; # Logout/Red Text -> Blue
    "#d35640" = "#20B2AA"; # Rank 3 Text -> Light Sea Green
    "#ff7b00" = "#00d2ff"; # Pentagram Orange -> Cyan
    "#df9e54" = "#F9CF78"; # Count Item -> Gold
    "#151313" = "#08101C"; # Components Bg -> Dark Blue Input
    "#181717" = "#0E1A2B"; # List/Streamer Bg -> Surface Blue
    "#0f0f0f" = "#0E1A2B"; # Market Card Bg -> Surface Blue
    "rgb(18, 17, 17)" = "#001225"; # Tables -> Deep Blue
    "rgb(21, 19, 19)" = "#0E1A2B"; # Nav Items -> Surface Blue
    "rgb(89, 11, 11)" = "#1A4B8C"; # Nav Active -> Dark Blue
    "#222121" = "#1F2E45"; # Borders -> Blue-Grey
    "#282626" = "#1F2E45"; # Borders -> Blue-Grey
    "#312d2d" = "#1F2E45"; # Borders -> Blue-Grey
    "rgb(31, 28, 28)" = "#1F2E45"; # Borders -> Blue-Grey
    "rgba(32, 31, 31, 0.555)" = "rgba(26, 38, 57, 0.555)"; # Transp. Borders -> Cool Blue-Grey
    "rgba(255, 123, 0, 0.21)" = "rgba(0, 210, 255, 0.21)"; # Pentagram Gradient -> Cyan
    "#b9b9b9" = "#a0aab5"; # Warm Grey Shadow -> Cool Grey
    "#831f05" = "#0a3d62"; # Rank 3 Shadow (Red) -> Dark Blue
    "#bba007" = "#bba007"; # Rank 1 (Gold) -> Keep Gold
    "#815d08" = "#815d08"; # Count Shadow (Gold) -> Keep Gold
    "#ced4da" = "#ced4da"; # Bootstrap grey -> Keep
    "#d2d0d0" = "#d0dbe5"; # Text Grey -> Cool Grey
    "#969696" = "#94a0b0"; # Text Grey -> Cool Grey
    "#686464" = "#647080"; # Text Grey -> Cool Grey
    "#787777" = "#708090"; # Text Grey -> Cool Grey
    "#bbbbbb" = "#b0c0d0"; # Text Grey -> Cool Grey
    "#e0e0e0" = "#e0e6ed"; # Text Grey -> Cool Grey
    "#cecece" = "#cedee8"; # Text Grey -> Cool Grey
    "#262424" = "#1A222E"; # List Group Border -> Dark Blue Grey
    "rgb(18 17 17)" = "#001225"; # Lootbox Shadow -> Deep Blue
}

foreach ($key in $replacements.Keys) {
    $pattern = Escape-Regex $key
    $replacement = $replacements[$key]
    $content = $content -ireplace $pattern, $replacement
}

Set-Content -Path $cssPath -Value $content -NoNewline
Write-Host "Phase 2 color refinement complete."
