DOMLoaded(() => {
	const coinFromSelect = document.getElementById('coin-from');
	const coinToSelect = document.getElementById('coin-to');

	const walletFromSelect = document.getElementById('wallet-from');
	const walletToSelect = document.getElementById('wallet-to');

	if (coinFromSelect) {
		coinFromSelect.addEventListener('change', async e => {
			coinToSelect.setAttribute('disabled', '');
			coinToSelect.innerHTML = '<option value=""></option>';

			const response = await fetch(`${window.Morpheus.basePath}exchange/available-coins/${coinFromSelect.value}`);
			const json = await response.json();

			for (let coin in json.coins) {
				coinToSelect.innerHTML += `<option value="${coin}">${json.coins[coin]}</option>`
			}

			coinToSelect.removeAttribute('disabled');
		});
	}

	if (walletFromSelect) {
		walletFromSelect.addEventListener('change', async e => {
			walletToSelect.setAttribute('disabled', '');
			walletToSelect.innerHTML = '<option value=""></option>';

			const response = await fetch(`${window.Morpheus.basePath}exchange/available-wallets/${walletFromSelect.value}`);
			const json = await response.json();

			for (let wallet in json.wallets) {
				walletToSelect.innerHTML += `<option value="${wallet}">${json.wallets[wallet]}</option>`
			}

			walletToSelect.removeAttribute('disabled');
		});
	}

	const calculateRateFields = document.querySelectorAll('[data-calculate-rate]');
	calculateRateFields.forEach(el => {
		el.addEventListener('change', async e => {
			const amountInput = document.getElementById('coin-amount');
			const changeAmount = document.getElementById('change-amount');
			const changeAmountText = document.getElementById('change-amount-text');
			const changeTax = document.getElementById('change-tax');
			const changeTaxText = document.getElementById('change-tax-text');

			function hideChangeInfo() {
				changeAmountText.style.display = 'none';
				changeTaxText.style.display = 'none';
				changeAmount.innerText = '';
				changeTax.innerText = '';
			}

			if (amountInput.value && coinFromSelect.value && coinToSelect.value) {
				const headers = new Headers();
				headers.append('Accept', 'application/json');
				const response = await fetch(`${window.Morpheus.basePath}exchange/calculate-rate?amount=${amountInput.value}&from=${coinFromSelect.value}&to=${coinToSelect.value}`, { headers });
				const json = await response.json();

				const dialog = new Dialog();

				if (json.success) {
					changeAmountText.style.display = 'block';
					changeAmount.innerText = `${json.amount} ${json.coin}`;

					if (json.tax > 0) {
						changeTaxText.style.display = 'block';
						changeTax.innerHTML = `${json.tax} ${json.tax_coin}`;
					}
				} else {
					hideChangeInfo();
					if (json.errors) {
						await dialog.error(Object.values(json.errors)[0]);
					} else {
						await dialog.error(json.error);
					}
				}
			} else {
				hideChangeInfo();
			}
		});
	});

	const calculateRateWalletFields = document.querySelectorAll('[data-calculate-wallet-rate]');
	calculateRateWalletFields.forEach(el => {
		el.addEventListener('change', async e => {
			const amountInput = document.getElementById('wallet-amount');
			const changeAmount = document.getElementById('change-amount');
			const changeAmountText = document.getElementById('change-amount-text');
			const changeTax = document.getElementById('change-tax');
			const changeTaxText = document.getElementById('change-tax-text');

			function hideChangeInfo() {
				changeAmountText.style.display = 'none';
				changeTaxText.style.display = 'none';
				changeAmount.innerText = '';
				changeTax.innerText = '';
			}

			if (amountInput.value && walletFromSelect.value && walletToSelect.value) {
				const headers = new Headers();
				headers.append('Accept', 'application/json');
				const response = await fetch(`${window.Morpheus.basePath}exchange/wallet/calculate-rate?amount=${amountInput.value}&from=${walletFromSelect.value}&to=${walletToSelect.value}`, { headers });
				const json = await response.json();

				const dialog = new Dialog();

				if (json.success) {
					changeAmountText.style.display = 'block';
					changeAmount.innerText = `${json.amount} ${json.wallet}`;

					if (json.tax > 0) {
						changeTaxText.style.display = 'block';
						changeTax.innerHTML = `${json.tax} ${json.tax_wallet}`;
					}
				} else {
					hideChangeInfo();

					if (json.errors) {
						await dialog.error(Object.values(json.errors)[0]);
					} else {
						await dialog.error(json.error);
					}
				}
			} else {
				hideChangeInfo();
			}
		});
	});
});