<?php
    if (isset($ranking) && isset($ranking['data']) && is_array($ranking['data'])) {
        $raw = $ranking['data'];
    } elseif (isset($data) && is_array($data)) {
        $raw = $data;
    } elseif (isset($players) && is_array($players)) {
        $raw = $players;
    } else {
        $raw = [];
    }
    
    if (empty($raw)) {
        echo '<p class="text-center mt-3">' . __('No results found') . '</p>';
        $top3 = [];
        $rest = [];
    } else {
        $players = array_values($raw);
        usort($players, function ($a, $b) {
            $va = isset($a['score']) ? intval($a['score']) : 0;
            $vb = isset($b['score']) ? intval($b['score']) : 0;
            return $vb <=> $va;
        });

        $top3 = array_slice($players, 0, 3);
        $rest = array_slice($players, 3);
    }

    $medals = [
        1 => asset_to('/images/1.png'),
        2 => asset_to('/images/2.png'),
        3 => asset_to('/images/3.png'),
    ];