$cssPath = "e:\Projetos\Mutronic\2026\site_v1.1\site\templates\tronic\assets\css\app.css"
$content = Get-Content -Path $cssPath -Raw

# Define replacements
$replacements = @{
    "#741010" = "#3794FF"; # Primary Red -> Blue
    "#470707" = "#1A4B8C"; # Darker Red -> Darker Blue
    "#963333" = "#3794FF"; # Red Gradient -> Blue
    "#97341f" = "#3794FF"; # Red Accent -> Blue Accent
    "#7a0e0e" = "#3794FF"; # Red Checkbox -> Blue
    "#b01e1e" = "#F9CF78"; # Red Link -> Gold
    "#0B0B0B" = "#070A11"; # Bg Black -> Dark Blue/Black
    "#0F0E0E" = "#001225"; # Bg Dark -> Deep Blue
    "#0f0d0d" = "#08101C"; # Input Bg -> Dark Blue Input
    "#121111" = "#001225"; # Card/Footer -> Deep Blue
    "#161515" = "#081424"; # Checkbox Bg -> Dark Blue Checkbox
    "#1b1919" = "#1A2639"; # Border -> Blue-Grey
    "#252424" = "#1F2E45"; # Border -> Blue-Grey
    "#2b2828" = "#1F2E45"; # HR -> Blue-Grey
    "#1a1919" = "#0D1929"  # Social Button -> Dark Blue
}

foreach ($key in $replacements.Keys) {
    # Escape regex special characters in the key if necessary (hex codes are safe usually but good practice)
    # Using case-insensitive replace
    $content = $content -ireplace $key, $replacements[$key]
}

Set-Content -Path $cssPath -Value $content -NoNewline
Write-Host "Color replacement complete."
