<?php
    $item = $item ?? [];
    $isNew = false;

    if (!empty($item['selling_start_date'])) {
        try {
            $postDate = new DateTimeImmutable($item['selling_start_date']);
            $twentyFourHoursAgo = new DateTimeImmutable('-24 hours');
            if ($postDate >= $twentyFourHoursAgo) {
                $isNew = true;
            }
        } catch (Exception $e) {

            $isNew = false;
        }
    }

    if (!isset($item['item']) || !is_object($item['item'])) {
        return;
    }

    $imgExtraClass = '';
    if (isset($item['item_section']) && $item['item_section'] == 0) {
        $imgExtraClass = 'weapon_rotate';
    }

    $item_detail_url = isset($item['id']) ? url_to('/market/item/' . $item['id']) : '#';
    $seller_name = isset($item['account']) ? account($item['account'])->getName() : 'Unknown Seller';

    $expireTimestampISO = null;
    $minutesToExpire = config('market.items.minutes_expire');

    if (!empty($item['selling_start_date']) && is_numeric($minutesToExpire) && $minutesToExpire > 0) {
        try {
            $startDate = new DateTimeImmutable($item['selling_start_date']);
            $expireDate = $startDate->modify("+" . (int)$minutesToExpire . " minutes");
            $expireTimestampISO = $expireDate->format(DateTime::ATOM);
        } catch (Exception $e) {

            $expireTimestampISO = null;
        }
    }

?>