/*===================================================
    Navbar 
===================================================*/
window.addEventListener("scroll", function () {
  if (window.scrollY > 300) {
    document.querySelector(".navbar").classList.add("navbar-fixed");
  } else {
    document.querySelector(".navbar").classList.remove("navbar-fixed");
  }
});

// Labels
const inputGroup = document.querySelectorAll(".input-group");
//  recuperando todos elementos com a div input-group
inputGroup.forEach((input) => {
  // selecionando todos os inputs e adicionando méotod focus
  input.children[0].addEventListener("focus", function () {
    // Selecionando o label do input
    input.children[1].classList.add("label-active");
  });
  // se caso o input for desfocado remova o seletor labe-active
  input.children[0].addEventListener("blur", function () {
    if (input.children[0].value === "") {
      input.children[1].classList.remove("label-active");
    }
  });
});

/*===================================================
    Radial progress Online
===================================================*/

function drawProgress(canvasId, value, lineWidth, color) {
  const canvas = document.getElementById(canvasId); // Seleciona o canvas pelo ID
  if (!canvas) {
    return; // Sai da função se o canvas não for encontrado
  }

  const ctx = canvas.getContext("2d"); // Obtém o contexto 2D do canvas
  if (!ctx) {
    return; // Sai da função se o contexto não for obtido
  }

  const CANVAS_SIZE = 122; // Define o tamanho do canvas
  canvas.width = CANVAS_SIZE; // Define a largura do canvas
  canvas.height = CANVAS_SIZE; // Define a altura do canvas

  const x = canvas.width / 2; // Calcula o ponto X central do canvas
  const y = canvas.height / 2; // Calcula o ponto Y central do canvas
  const radius = Math.min(canvas.width, canvas.height) / 2 - lineWidth; // Calcula o raio para o arco

  const START_ANGLE = -Math.PI / 2; // Define o ângulo de início do arco
  const endAngle = START_ANGLE + (value / 100) * Math.PI; // Calcula o ângulo de fim com base no valor

  ctx.clearRect(0, 0, canvas.width, canvas.height); // Limpa o canvas

  ctx.beginPath(); // Inicia o caminho para desenhar o arco de progresso
  ctx.arc(x, y, radius, START_ANGLE, endAngle); // Cria o arco
  ctx.strokeStyle = color; // Define a cor da linha
  ctx.lineWidth = lineWidth; // Define a largura da linha
  ctx.stroke(); // Desenha o arco de progresso
}

/* Inicia a verificação do elemento e valor para o progresso radial */
function checkRadialProgressElement() {
  const radialProgressElement = document.querySelector("#radial_progress"); // Seleciona o elemento de progresso radial
  if (radialProgressElement) {
    // Verifica se o elemento existe
    const radialProgressValue = parseInt(
      radialProgressElement.getAttribute("data-radial-progress"),
      10
    ); // Obtém o valor do progresso radial
    if (!isNaN(radialProgressValue)) {
      // Verifica se o valor obtido é um número
      drawProgress("radial_progress", radialProgressValue, 5, "#00a600"); // Chama a função para desenhar o progresso radial
    } else {
      console.error("Valor de progresso radial inválido ou não encontrado."); // Exibe erro se o valor não for um número
    }
  } else {
    console.error("Elemento de progresso radial não encontrado."); // Exibe erro se o elemento não for encontrado
  }
}

/* Executa a verificação quando o documento estiver pronto */
document.addEventListener("DOMContentLoaded", checkRadialProgressElement);

/*
===================================================
  Limitando caracters textarea de comentários de postagens
=================================================== */

function maxCaractersComments() {
  const textarea = document.getElementById("comment_area");
  const maxLength = 300; // define o número máximo de caracteres permitidos
  const counterDiv = document.getElementById("comment_counter"); // seleciona a div para exibir a contagem
  if (textarea) {
    textarea.addEventListener("input", () => {
      const text = textarea.value;
      if (text.length > maxLength) {
        textarea.value = text.slice(0, maxLength); // corta o texto para o tamanho máximo permitido
      }
      counterDiv.textContent = `${text.length}/${maxLength}`; // atualiza o texto da div com a contagem
    });
  }
}

/*===================================================
  Hall fame Select
=================================================== */
function updateHallFameSelect() {
  $("#change-top-ranking").change(function () {
    var $this = $(this);
    var target = $this.val();

    $(".hall_fame").hide();
    $("#" + target).fadeIn();
  });
}

/*===================================================
  Dropdown menu
=================================================== */
function toggleDropdown() {
  var dropdownMenu = document.getElementById("dropdownMenu");
  if (dropdownMenu.style.display === "block") {
    dropdownMenu.style.display = "none";
  } else {
    dropdownMenu.style.display = "block";
  }
}

// Fechar o menu dropdown quando clicar fora dele
window.onclick = function (event) {
  if (!event.target.matches(".dropdown-toggle")) {
    var dropdownMenus = document.getElementsByClassName("dropdown-menu");
    for (var i = 0; i < dropdownMenus.length; i++) {
      var openDropdownMenu = dropdownMenus[i];
      if (openDropdownMenu.style.display === "block") {
        openDropdownMenu.style.display = "none";
      }
    }
  }
};

// Filtro de personagens
function filterCharacter() {
  var characterNameInput = document.getElementById("characterNameInput");
  var searchButton = document.getElementById("searchButton");

  function performSearch() {
    var characterName = characterNameInput.value.trim().toLowerCase();
    var tbody = document.querySelector("tbody");
    var rows = tbody.querySelectorAll("tr");

    // Remova a classe de destaque de pesquisas anteriores
    var highlightedRows = tbody.querySelectorAll(".highlight");
    for (var j = 0; j < highlightedRows.length; j++) {
      highlightedRows[j].classList.remove("highlight");
    }

    for (var i = 0; i < rows.length; i++) {
      var row = rows[i];
      var nameCell = row.querySelector("td.characterName");
      var characterNameInTable = nameCell
        ? nameCell.innerText.trim().toLowerCase()
        : "";

      if (characterNameInTable.includes(characterName)) {
        // Adicione a classe de destaque para o <tr> correspondente
        row.classList.add("highlight");

        // Role a página suavemente até a posição do <tr> encontrado
        var offsetTop = row.getBoundingClientRect().top + window.pageYOffset;
        var scrollToOptions = {
          top: offsetTop,
          behavior: "smooth",
        };
        window.scrollTo(scrollToOptions);
        break;
      }
    }
  }

  if (searchButton) {
    searchButton.addEventListener("click", performSearch);
  }
}

// Este código deve ser adicionado ao seu arquivo JavaScript ou dentro de uma tag <script> no HTML
$(document).on("pjax:start", function () {
  // Adiciona a barra de progresso no topo do site
  $("body").prepend(
    '<div id="loading-bar" style="position: fixed; top: 0; left: 0; height: 5px; background-color: gold; width: 0;"></div>'
  );

  $("#loading-bar").animate(
    {
      width: "100%",
    },
    {
      duration: 300, // Duração da animação
      easing: "linear", // Tipo de animação
      step: function (now, fx) {},
      complete: function () {
        // Opcional: este callback é chamado quando a animação está completa
      },
    }
  );
});

$(document).on("pjax:end", function () {
  // Remove a barra de progresso quando a requisição PJAX terminar
  $("#loading-bar").remove();
});

document.addEventListener("DOMContentLoaded", (event) => {
  // Verifica se o elemento com a classe 'list-flex-s-c' está no DOM
  const list = document.querySelector(".list-flex-s-c");
  if (list) {
    // Cria um observer para monitorar mudanças no elemento
    const observer = new MutationObserver((mutations) => {
      mutations.forEach((mutation) => {
        // Verifica se foi adicionado algum nó filho
        if (mutation.addedNodes.length) {
          mutation.addedNodes.forEach((node) => {
            // Verifica se o nó adicionado é um elemento e tem a classe 'event'
            if (node.nodeType === 1 && node.classList.contains("event")) {
              // Adiciona a classe 'list-group-item' ao elemento
              node.classList.add("list-group-item");
            }
          });
        }
      });
    });

    // Configura o observer para monitorar a adição de nós filhos
    observer.observe(list, { childList: true });
  }
});

// Hall Fame Select

$("#change-top-ranking").change(function () {
  var $this = $(this);
  var target = $this.val();

  $(".hall_fame").hide();
  $("#" + target).fadeIn();
});

$(document).on("pjax:end", function () {
  maxCaractersComments();
  drawProgress();
  filterCharacter();
  updateHallFameSelect();
});
